$(document).ready(function() {
    $(document).ready( function () {
        $('#datatable-buttons').DataTable();
    });


    $('#tipo').on('change', function() {
        const tipo = $(this).val();
        const valorInput = $('#valor');

        // Limpiar los atributos min y max
        valorInput.removeAttr('min').removeAttr('max');

        if (tipo == 2) {
            // Si el tipo es 2, establecer min y max
            valorInput.attr('min', '1');
            valorInput.attr('max', '100');
        }
    });
    $('#generarCodigo').click(function() {
        var codigo = generarCodigoAlfanumerico();
        $('#codigo').val(codigo); // Coloca el código generado dentro del input

        // Enviar el código por POST a PHP
        $.ajax({
            url: 'acciones/validarcode.php', // Reemplaza con la ruta de tu archivo PHP
            method: 'POST',
            data: { codigo: codigo },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    // Si el servidor responde true, generar un nuevo código
                    var nuevoCodigo = generarCodigoAlfanumerico();
                    $('#codigo').val(nuevoCodigo); // Reemplazar con un nuevo código
                } else {
                    // Si es false, continuar normalmente
                    console.log('Continuando con el código original: ' + codigo);
                }
            },
            error: function(xhr, status, error) {
                console.error('Error al enviar el código: ' + error);
            }
        });
    });
    
    $('#fechaInicio').change(function() {
        var fechaInicio = $(this).val();
        $('#fechaFin').attr('min', fechaInicio); // Establece la fecha mínima de fin como la fecha de inicio
    });

    $('#fechaFin').change(function() {
        var fechaInicio = $('#fechaInicio').val();
        var fechaFin = $(this).val();

        if (fechaFin < fechaInicio) {
            alert('La fecha de fin no puede ser anterior a la fecha de inicio');
            $(this).val(''); // Borra la fecha de fin si no es válida
        }
    });
    
    function generarCodigoAlfanumerico() {
        var caracteres = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        var codigo = '';
        for (var i = 0; i < 8; i++) {
            var randomIndex = Math.floor(Math.random() * caracteres.length);
            codigo += caracteres.charAt(randomIndex);
        }
        return codigo;
    }
    
    
    
    

});

function eliminarcupon(id) {
        Swal.fire({
            title: '¿Estás seguro de eliminar este cupón?',
            text: "Esta acción no se puede deshacer",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'No, cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                // Enviar el ID por POST al archivo eliminarcupon.php
                $.ajax({
                    url: 'acciones/eliminarcupon.php',
                    type: 'POST',
                    data: { id: id },
                    dataType: 'json',
                    success: function(response) {
                        var json = JSON.parse(response); 
                        viewmodal(json[0].idmodal,json[0].titlemsg,json[0].msg);
                        if(json[0].idtabl){tableleccion(json[0].idtable,json[0].table);}
                        if(json[0].rtr){removetr(json[0].rtr);}
                        if(json[0].table){uptable(json[0].table);}
                    },
                    error: function() {
                        Swal.fire(
                            'Error!',
                            'Ocurrió un error en la solicitud. Inténtalo de nuevo.',
                            'error'
                        );
                    }
                });
            }
        });
    }
