$(document).ready(function () {
    $("#datatable").DataTable({
        language: {
            paginate: {
                previous: "<i class='mdi mdi-chevron-left'>",
                next: "<i class='mdi mdi-chevron-right'>"
            }
        },
        drawCallback: function () {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded");
        },
        serverSide: true, // Agregado para habilitar el procesamiento del lado del servidor
        processing: true, // Dejarlo como false inicialmente
        ajax: {
            url: "server-side/usuarios.php", // URL inicial
            type: "POST",
            data: function (d) {
                // Agregar parámetros adicionales si es necesario
                d.extra_param = "valor";
            }
        }
    });
    var a = $("#datatable-buttons").DataTable({
        lengthMenu: [10, 25, 50, 100, -1],
        lengthChange: true,
        language: {
            paginate: {
                previous: "<i class='mdi mdi-chevron-left'>",
                next: "<i class='mdi mdi-chevron-right'>"
            }
        },
        drawCallback: function () {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded");
        },
        buttons: [
            {
                extend: 'excelHtml5',
                text: 'Exportar a Excel',
                titleAttr: 'Exportar a Excel',
                className: 'btn btn-success',
                exportOptions: {
                    modifier: {
                        page: 'all'
                    }
                }
            }
        ],
        order: [[9, "desc"]],
        serverSide: true, // Agregado para habilitar el procesamiento del lado del servidor
        processing: true, // Dejarlo como false inicialmente
        ajax: {
            url: "server-side/usuarios.php", // URL inicial
            type: "POST",
            data: function (d) {
                // Agregar parámetros adicionales si es necesario
                d.idperfil =  $("#filtroCategoria").val();
            }
        }
    });
    // Agrega el botón al contenedor existente
    new $.fn.dataTable.Buttons(a, {
            buttons: [
                {
                    extend: 'excelHtml5',
                    text: 'Exportar a Excel',
                    titleAttr: 'Exportar a Excel',
                    className: 'btn btn-success',
                    exportOptions: {
                        modifier: {
                            page: 'all'
                        }
                    }
                }
            ]
        });

        // Coloca los botones en el contenedor
        a.buttons().container().appendTo($('#tablaDatos_wrapper .col-md-6:eq(0)'));
    $("#filtroCategoria").change(function () {
            // Recargar la DataTable con la nueva opción
            a.ajax.reload();
        });
      
    $("#selection-datatable").DataTable({
        select: {
            style: "multi"
        },
        language: {
            paginate: {
                previous: "<i class='mdi mdi-chevron-left'>",
                next: "<i class='mdi mdi-chevron-right'>"
            }
        },
        drawCallback: function () {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded");
        },
        serverSide: true, // Agregado para habilitar el procesamiento del lado del servidor
        processing: true, // Dejarlo como false inicialmente
        ajax: {
            url: "server-side/usuarios.php", // URL inicial
            type: "POST",
            data: function (d) {
                // Agregar parámetros adicionales si es necesario
                d.extra_param = "valor";
            }
        }
    });

    $("#key-datatable").DataTable({
        keys: true,
        language: {
            paginate: {
                previous: "<i class='mdi mdi-chevron-left'>",
                next: "<i class='mdi mdi-chevron-right'>"
            }
        },
        drawCallback: function () {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded");
        },
        serverSide: true, // Agregado para habilitar el procesamiento del lado del servidor
        processing: true, // Dejarlo como false inicialmente
        ajax: {
            url: "server-side/usuarios.php", // URL inicial
            type: "POST",
            data: function (d) {
                // Agregar parámetros adicionales si es necesario
                d.extra_param = "valor";
            }
        }
    });

    a.buttons().container().appendTo("#datatable-buttons_wrapper .col-md-6:eq(0)");

    $("#alternative-page-datatable").DataTable({
        pagingType: "full_numbers",
        drawCallback: function () {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded");
        },
        serverSide: true, // Agregado para habilitar el procesamiento del lado del servidor
        processing: true, // Dejarlo como false inicialmente
        ajax: {
            url: "server-side/usuarios.php", // URL inicial
            type: "POST",
            data: function (d) {
                // Agregar parámetros adicionales si es necesario
                d.extra_param = "valor";
            }
        }
    });

    $("#scroll-vertical-datatable").DataTable({
        scrollY: "350px",
        scrollCollapse: true,
        paging: false,
        language: {
            paginate: {
                previous: "<i class='mdi mdi-chevron-left'>",
                next: "<i class='mdi mdi-chevron-right'>"
            }
        },
        drawCallback: function () {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded");
        },
        serverSide: true, // Agregado para habilitar el procesamiento del lado del servidor
        processing: true, // Dejarlo como false inicialmente
        ajax: {
            url: "server-side/usuarios.php", // URL inicial
            type: "POST",
            data: function (d) {
                // Agregar parámetros adicionales si es necesario
                d.extra_param = "valor";
            }
        }
    });

    $("#complex-header-datatable").DataTable({
        language: {
            paginate: {
                previous: "<i class='mdi mdi-chevron-left'>",
                next: "<i class='mdi mdi-chevron-right'>"
            }
        },
        drawCallback: function () {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded");
        },
        columnDefs: [{
            visible: !1,
            targets: -1
        }],
        serverSide: true, // Agregado para habilitar el procesamiento del lado del servidor
        processing: true, // Dejarlo como false inicialmente
        ajax: {
            url: "server-side/usuarios.php", // URL inicial
            type: "POST",
            data: function (d) {
                // Agregar parámetros adicionales si es necesario
                d.extra_param = "valor";
            }
        }
    });

    $("#state-saving-datatable").DataTable({
        stateSave: true,
        language: {
            paginate: {
                previous: "<i class='mdi mdi-chevron-left'>",
                next: "<i class='mdi mdi-chevron-right'>"
            }
        },
        drawCallback: function () {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded");
        },
        serverSide: true, // Agregado para habilitar el procesamiento del lado del servidor
        processing: true, // Dejarlo como false inicialmente
        ajax: {
            url: "server-side/usuarios.php", // URL inicial
            type: "POST",
            data: function (d) {
                // Agregar parámetros adicionales si es necesario
                d.extra_param = "valor";
            }
        }
    });
});
