<?php
$r="../../";
require_once($r."config/config.php");
$mysqli = connectDB($r);
/*
 * DataTables example server-side processing script.
 *
 * Please note that this script is intentionally extremely simple to show how
 * server-side processing can be implemented, and probably shouldn't be used as
 * the basis for a large complex system. It is suitable for simple use cases as
 * for learning.
 *
 * See http://datatables.net/usage/server-side for full details on the server-
 * side processing requirements of DataTables.
 *
 * @license MIT - http://datatables.net/license_mit
 */
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'usuarios';
 
// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => 'id', 'dt' => 'id' ),
    array( 'db' => 'nombre',  'dt' => 'nombre' ),
    array( 'db' => 'correo',   'dt' => 'correo' ),
    array( 'db' => 'idcreador',     'dt' => 'conferencista' ),
    array(
        'db'        => 'proceso',
        'dt'        => 'estado',
        'formatter' => function( $d, $row ) {
             $infoproce = sinfo($row['proceso'],'procesos'); return $infoproce['proceso'];
        }
    ),
    array(
        'db'        => 'contacto',
        'dt'        => 'acciones',
        'formatter' => function( $d, $row ) {
            $response = '<i style="cursor:pointer" title="Actualizar '.$row['nombre'].'" onclick="editar('.$d.')" class="fa-lg ri-pencil-fill"></i>';
            $response .= '<i style="cursor:pointer" title="Actualizar '.$row['estado'].'" onclick="editar('.$d.')" class="fa-lg ri-pencil-fill"></i>'; 
            $response .= '<i style="cursor:pointer" title="Actualizar '.$row['nombre'].'" onclick="editar('.$d.')" class="fa-lg ri-pencil-fill"></i>';
            return $response;
        }
    )
);
 
// SQL server connection information


$sql_details = array(
    'user' => $userbd,
    'pass' => $passbd,
    'db'   => $bd,
    'host' => $server
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
require( 'ssp.class.php' );


//$tabla = SSP::simple( $_POST, $sql_details, $table, $primaryKey, $columns );
echo json_encode(
    SSP::simple( $_POST, $sql_details, $table, $primaryKey, $columns )
);
?>