
var player = new Vimeo.Player($('#vimeoPlayer')[0]);
var lessonview=2;
var timevideo=0;
var idlecg=0;
var audio = $("#myAudio")[0]; // Obtén el elemento de audio usando jQuery
audio.volume = 0.090;
var playPauseBtn = $(".play-pause-btn");

function lesson(idtema, idleccion) {
    

    $.ajax({
        url: 'leccion.php',
        type: 'POST',
        data: { idleccion },
        success: function (data) {
            var jsonData = JSON.parse(data);
            var player = initializePlayer(jsonData[0].vimeo);
            
            //player.play();
            
            idlecg = idleccion;
            updateLessonUI(jsonData[0]);
        }
    });
    
    UIkit.modal('#lesson').show();
}
    
    function initializePlayer(vimeoId) {
        var player = new Vimeo.Player('vimeoPlayer', { id: vimeoId });

        player.loadVideo(vimeoId)
            .then(function (data) {
                console.log("Vimeo loadVideo called", data);
                //progress();
                
            })
            .catch(function (error) {
                console.error("Load video error!");
            });
        
        return player;
    }
    
     // Escuchar el evento pause
    player.on('pause', function(data) {
        console.log("Video is paused");
        var currentTime = data.seconds;
        var duration = data.duration;
        // Calcular el porcentaje de progreso del video
        var percent = (currentTime / duration) * 100;
        
        // Enviar el porcentaje mediante AJAX
        var idleccion = idlecg; // Suponiendo que tienes la variable idlecg definida en otro lugar
        if(percent>lessonview){
            $.ajax({
                url: 'acciones/progreso.php',
                type: 'POST',
                data: { video: idleccion, porcen: percent },
                success: function(data) {
                    $('#t'+idleccion).html('<i style="color:#03588C" class="fa fa-check"></i>');
                },
                error: function(xhr, status, error) {
                    // Manejar errores si es necesario
                }
            });
        }
    });

    // Escuchar el evento ended
    player.on('ended', function(data) {
        console.log("Video has ended");
        var currentTime = data.seconds;
        var duration = data.duration;
        
        // Calcular el porcentaje de progreso del video
        var percent = (currentTime / duration) * 100;
        
        // Enviar el porcentaje mediante AJAX
        var idleccion = idlecg; // Suponiendo que tienes la variable idlecg definida en otro lugar
        if(percent>lessonview){
            $.ajax({
                url: 'acciones/progreso.php',
                type: 'POST',
                data: { video: idleccion, porcen: percent },
                success: function(data) {
                    $('#t'+idleccion).html('<i style="color:#03588C" class="fa fa-check"></i>');
                },
                error: function(xhr, status, error) {
                    // Manejar errores si es necesario
                }
            });
        }
    });
     
    
    player.ready().then(function() {
        player.on('pause', function(data) {
            audio.pause();
            playPauseBtn.html("<i class='fa fa-bell'></i>");
        });
    });
    

    function updateLessonUI(lessonData) {
        $('#titlelesson').html(lessonData.nombre);
        $('#textlesson').html(lessonData.descripcion);
        $('#fileleccion').html(lessonData.archivos);
        audio.src = "audios/" + lessonData.audio;

        updateArrows(idtema, idleccion);
    }

    function updateArrows(idtema, idleccion) {
        var lecciones = $("#lecciones" + idtema).val().replace(/"/gi, '');
        var lessonArray = JSON.parse(lecciones);
        var key = lessonArray.indexOf(idleccion);
        var prev = lessonArray[key - 1];
        var last = lessonArray[key + 1];

        $('i.fa-arrow-left').attr('onclick', 'lesson(' + idtema + ',' + prev + ')');
        $('i.fa-arrow-right').attr('onclick', 'lesson(' + idtema + ',' + last + ')');
    }
    





function togglePlayPause() {
    if (audio.paused) {
      audio.play();
      playPauseBtn.html("<i class='fa fa-bell-slash'></i>");
      
    } else {
      audio.pause();
      playPauseBtn.html("<i class='fa fa-bell'></i>");
    }
}
  
function buy(){
    UIkit.modal('#buy').show();
}

function progress(){
    player.on('timeupdate', function (data) {
        timevideo = data;
    });
    var time = timevideo['percent'];
    var idleccion= idlecg;
    $.ajax({
        url: 'acciones/progreso.php',
        type: 'POST',
        data: 'video=' + idleccion + '&porcen=' + time,
        success: function(data){}
    });
    
}

$('#lesson').on('hidden', function () {
    //player.loadVideo('223541751');
    player.pause().then(function() {
        audio.pause();
        playPauseBtn.html("<i class='fa fa-bell'></i>");
    });
})

