$(document).ready(function() {
    $("#pais").on('change', function() {
        var id = $(this).val();
        $.ajax({
            url: 'admin/funciones/allselect.php' ,
            type: "post",
            data: { 'idpais':id},
            success: function(data){
                $('#departamento').html(data).slideDown(400);
                $('#municipio').html('').slideDown(400);
                $('#yociudad').val('');
            }
        })
    });
    $("#departamento").on('change', function() {
        var id = $(this).val();
        $.ajax({
            url: 'admin/funciones/allselect.php' ,
            type: "post",
            data: { 'iddepa':id},
            success: function(data){
                $('#municipio').html(data).slideDown(400);
                yociudad();
            }
        })
    });
    $("#formulario").submit(function(e) {
        e.preventDefault();
        $("input.uk-button").attr('disabled','disabled');
        $("button.uk-button").attr('disabled','disabled');
        UIkit.modal('#divprocesa').show();
        //$('#divprocesando').removeClass('d-none');
        var action = $(this).attr('action');
        var type = $(this).attr('method');
        var formData = new FormData(this);
        $.ajax({
            url: action,
            type: type,
            data: formData,
            contentType: false, //this is requireded please see answers above
            processData: false, //this is requireded please see answers above
            success: function(data){
                var json = JSON.parse(data);
                if (json[0].pag.match('.php') !== null){
                    UIkit.modal.alert(json[0].msg)
                    setTimeout(function(){ window.location.replace(json[0].pag); }, 10000);
                    window.open(json[0].file, "contrato", "width=500,height=500");
                }
                else{ UIkit.modal.alert(json[0].msg);}
                 
            },
            error: function (jqXHR, exception) {
                errores(jqXHR, exception);
                UIkit.modal('#divproces').hide();
            }
        });
        $("input.uk-button").removeAttr('disabled','disabled');
    });
    $("#examen").submit(function(e) {
        e.preventDefault();
        $("input.uk-button").attr('disabled','disabled');
        $('#divprocesando').removeClass('d-none');
        var action = $(this).attr('action');
        var type = $(this).attr('method');
        var formData = new FormData(this);
        $.ajax({
            url: action,
            type: type,
            data: formData,
            contentType: false, //this is requireded please see answers above
            processData: false, //this is requireded please see answers above
            success: function(data){
                $('#examen').html(data);
            },
            error: function (jqXHR, exception) {
                errores(jqXHR, exception);
            }
        });
        $("input.uk-button").removeAttr('disabled','disabled');
    });
});

function errores(jqXHR, exception){
    var msg = '';
    if (jqXHR.status === 0) {
        msg = '<div class="alert alert-dark" role="alert">Sin conexión.\n Verificar tu conexion a internet</div>';
    } else if (jqXHR.status == 404) {
        msg = '<div class="alert alert-dark" role="alert">Pagina solicitada no encontrada. [404]</div>';
    } else if (jqXHR.status == 500) {
        msg = '<div class="alert alert-dark" role="alert">Error interno del servidor [500].</div>';
    } else if (exception === 'parsererror') {
        msg = '<div class="alert alert-dark" role="alert">Error al analizar JSON solicitado.</div>';
    } else if (exception === 'timeout') {
        msg = '<div class="alert alert-dark" role="alert">Error de tiempo de espera</div>';
    } else if (exception === 'abort') {
        msg = '<div class="alert alert-dark" role="alert">Solicitud Ajax abortada.</div>';
    } else {
        msg = '<div class="alert alert-dark" role="alert">Error no detectado.\n' + jqXHR.responseText+'</div>';
    }
   UIkit.notification(msg, {status: 'primary',pos: 'bottom-right'})
}

