<?php
$r= '../';
$titlepage='SOLICITUDES DE ENTRADA';
require_once($r."inc/config.php");
validSession($r);
$mysqli = connectDB($r);
$spe = $_SESSION['perfil'];
$idusuario = $_SESSION['userid'];
roleaccess(410);
include $r."inc/head.php"; ?>

<body class="fixed-nav sticky-footer sidenav-toggled bg-dark" id="page-top">
    <?php include $r."inc/nav.php"; ?>
 
    <div class="content-wrapper">
        <div class="container-fluid">
          <!-- Example DataTables Card-->
          <div class="card mb-3">
            <div class="h3 card-header">
              <i class="fa fa-table"></i> <?= $titlepage; ?>
              <button class="btn btn-primary float-right" onclick="NewEntrada()"><i class="fa fa-plus mr-2"></i>Nueva Entrada</button>
              
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-bordered table-striped" id="dataTable" width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th>Codigo</th>
                      <th>Empresa</th>
                      <th>Recibió</th>
                      <th>Entrego</th>
                      <th>Vehiculo</th>
                      <th>Documento</th>
                      <th>Estado</th>
                      <th>Fecha</th>
                      <th style="max-width: 120px;"><i class="fa fa-gear"></i></th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th>Codigo</th>
                      <th>Empresa</th>
                      <th>Recibió</th>
                      <th>Entrego</th>
                      <th>Vehiculo</th>
                      <th>Documento</th>
                      <th>Estado</th>
                      <th>Fecha</th>
                      <th style="max-width: 120px;"><i class="fa fa-gear"></i></th>
                    </tr>
                  </tfoot>
                  <tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
    </div>
    <style>
    .chosen-container {
        width: 100%!important;
    }
    .sweet-overlay{
        z-index:1999;
    }
    #ModalAddProductoEntrada{
        z-index:1060!important;
        background: rgba(0, 0, 0, 0.4);
    }
    #seriales{
        display:block;
        padding: 4px;
    }
    .serial{
            border: 1px solid #000;
        border-radius: 20px;
        display: inline-block;
        padding: 0px;
        background: #d7d7d7;
    }
    .serial input{
        border: none;
        background: none;
        text-align: center;
    }
    .serial i{
        color:red;
        margin-right:3px;
    }
    @media (min-width: 1140px) {
        .modal-lg {
            max-width: 1000px; /* Ancho del modal para pantallas grandes */
        }
    }
    </style>
    <!-- The Modal Nueva Entrada-->
    <div class="modal" id="ModalNewEntrada">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <!-- Modal body -->
          <div class="modal-body">
                <form id="newformulario" action="acciones.php" method="POST">
                    <input type="hidden" name="addentrada" value="TRUE">
                    <div class="form-group">
                        <label>Empresa</label>
                        <select name="cliente" id="ModalNewEntradaCliente" class="chosen-select">
                          <option value="" selected disabled>Seleccione una empresa...</option>
                          <?php $qry1 = $mysqli->query("SELECT * FROM z_usuarios_empresas"); while($row1 = $qry1->fetch_assoc()){ ?><option class="text-uppercase" value="<?= $row1['id']; ?>"><?= $row1['empresa']; ?></option><? } ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Prueba de entrada:</label>
                        <select name="idprueba" class="chosen-select">
                          <option value="" selected disabled>Seleccione una empresa...</option>
                          <?php $qry1 = $mysqli->query("SELECT * FROM z_solicitudes_entrada_prueba WHERE identrada IS NULL"); while($row1 = $qry1->fetch_assoc()){ ?><option class="text-uppercase" value="<?= $row1['id']; ?>"><?= $row1['id'].' - '.$row1['entrega'].' - '.$row1['placa']; ?></option><? } ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Entregado Por:</label>
                        <input type="text" name="entregado" class="form-control" placeholder="Entregado Por..." required>
                    </div>
                    <div class="form-group">
                        <label>Remesa/Remision</label>
                        <input type="text" name="remision" class="form-control" placeholder="Remesa/Remision..." required>
                    </div>
                    <div class="form-group">
                        <label>Placa</label>
                        <input type="text" name="placa" class="form-control" placeholder="Placa Vehiculo..." required>
                    </div>
                    <div class="form-group">
                        <label>Comentarios</label>
                        <input type="text" name="nota" class="form-control" placeholder="Comentario Adicional...">
                    </div>
                </form>
                <table class="table table-bordered table-striped" id="intable" width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th>Producto</th>
                      <th>Cantidad</th>
                      <th>Estado</th>
                      <th>Nota</th>
                      <th>Seriales</th>
                      <th>Soporte</th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th>Producto</th>
                      <th>Cantidad</th>
                      <th>Estado</th>
                      <th>Nota</th>
                      <th>Seriales</th>
                      <th>Soporte</th>
                    </tr>
                  </tfoot>
                  <tbody>
                    <tr id="sindata" class="odd"><td valign="top" colspan="6" class="dataTables_empty text-center">No hay productos cargados</td></tr>
                  </tbody>
                </table>
                <button class="btn btn-success btn-block" onclick="addProductoEntrada()"><i class="fa fa-plus mr-2"></i>Agregar Producto</button>
          </div>
          
            
          <!-- Modal footer -->
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" form="newformulario" class="btn btn-primary" >FINALIZAR</button>
          </div>
    
        </div>
      </div>
    </div>
    
    <!-- The Modal Infomacion -->
    <div class="modal" id="ModalAddProductoEntrada">
      <div class="modal-dialog  modal-xl">
        <div class="modal-content">
          <!-- Modal body -->
          <div class="modal-body">
            
          </div>
          <!-- Modal footer -->
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" onclick="addProducto()" class="btn btn-primary" >AGREGAR</button>
          </div>
    
        </div>
      </div>
    </div>
    
    <!-- The Modal Infomacion -->
    <div class="modal" id="ModalInfo">
      <div class="modal-dialog  modal-lg">
        <div class="modal-content">
          <!-- Modal body -->
          <div class="modal-body">
            Modal body..
          </div>
          <!-- Modal footer -->
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" form="newformulario" class="btn btn-primary" data-dismiss="modal">ACTUALIZAR</button>
          </div>
    
        </div>
      </div>
    </div>
    
    <!-- The Modal Infomacion -->
    <div class="modal" id="ModalLoadFile">
      <div class="modal-dialog  modal-xl">
        <div class="modal-content">
          <!-- Modal body -->
          <div class="modal-body">
              
             <form id="uploadForm" enctype="multipart/form-data">
                <input type="hidden" name="idsoporte" value="">
                <div class="form-group">
                    <label>Documento Soporte</label>
                    <input type="file" name="soporte" class="form-control" placeholder="Documento Soporte...." required>
                </div>
            </form>
          </div>
          <!-- Modal footer -->
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" onclick="uploadSoporte()" class="btn btn-primary">ACTUALIZAR</button>
          </div>
    
        </div>
      </div>
    </div>
    
     <!-- The Modal Infomacion -->
    <div class="modal" id="ModalZone">
      <div class="modal-dialog  modal-xl">
        <div class="modal-content">
          <!-- Modal body -->
            <form id="modalZone" class="modal-body"action='acciones.php' method="POST" ></form>
          <!-- Modal footer -->
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" form="modalZone" class="btn btn-primary">ACTUALIZAR</button>
          </div>
    
        </div>
      </div>
    </div>
  <?php include $r."inc/foot.php"; ?>
  <script>
  var incremental = 1;
    $('#dataTable').DataTable({
      "order": [[0, 'desc']],
      "ordering": true,
      "processing": true,
      "serverSide": true,"ajax": {
      "url": 'server_side/entradas.php',
        
      },
      "dom": 'lfBtipr', // Agrega B para los botones
      "buttons": [
        'copy', 'csv', 'excel', 'pdf', 'print'
        // Puedes agregar más botones según tus necesidades
      ],
      // Otras configuraciones...
    });
    
    function NewEntrada(){
        $('#ModalNewEntrada').modal('show');
    }
    function loadfile(identrada){
        $('input[name=idsoporte]').val(identrada);
        $('#ModalLoadFile').modal('show');
    }
    function addProducto(){
        var idproducto = $('select[name=addproducto]').val();
        var pserial = $('select[name=addproducto] option:selected').attr('data-serial');
        var producto = $('select[name=addproducto] option:selected').text();
        var cantidad = $('input[name=addcantidad]').val();
        var idestado = $('select[name=addestado]').val();
        var estado = $('select[name=addestado] option:selected').text();
        var seriales = ""; 
        if(pserial==1){
            // Inicializa la variable seriales
            var nseriales = 0;
            $('input[name="seriales[]"]').each(function() {
                var valorActual = $(this).val().trim();
                nseriales++;
                seriales += valorActual + ","; // Concatena el valor actual y "/"
            });
            console.log(pserial);
            if(nseriales != cantidad){
                swal({
                    title: 'Oops...',
                    text: 'El numero de seriales no conside con la cantidad ingresada',
                    icon: 'error'
                });
                return;
            }
            seriales = seriales.slice(0, -1);
        }
        var nota = $('textarea[name=addnota]').val();
        // Validar que ningún campo esté vacío o nulo
        if (!idproducto || !producto || !cantidad || !idestado || !estado) {
            // Si algún campo está vacío o nulo, emitir un SweetAlert
            swal({
                title: 'Oops...',
                text: 'Todos los campos son requeridos',
                icon: 'error'
            });
            return; // Terminar la función sin continuar
        }else{
            $('#sindata').remove();
            swal('producto agregado');
            // Agregar una nueva fila al final del tbody
            $('#intable tbody').append('<tr><td><input type="hidden" name="idproducto['+incremental+']" form="newformulario" value="'+idproducto+'" >'+producto+'</td><td><input type="hidden" name="cantidad['+incremental+']" form="newformulario" value="'+cantidad+'" >'+cantidad+'</td><td><input type="hidden" name="estado['+incremental+']" form="newformulario" value="'+idestado+'" >'+estado+'</td><td><input type="hidden" name="notaproducto['+incremental+']" form="newformulario" value="'+nota+'" >'+nota+'</td><td><input type="hidden" name="seriales['+incremental+']" form="newformulario" value="'+seriales+'" >'+seriales+'</td><td  class="custom-file-upload"><input type="file" multiple name="archivo['+incremental+']" form="newformulario"></td></tr>');
            incremental++;
            $('#ModalAddProductoEntrada').modal('hide');
        }
    }
    
    function info(id){
        $.post( "acciones.php", { infoentrada: id })
          .done(function( response ) {
            if (response.success) {
                $('#ModalInfo').modal('show');
                $('#ModalInfo .modal-body').html(response.message);
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                swal(response.message);
            }
        });
    }
    
    function addProductoEntrada() {
        var ModalNewEntradaCliente = $('#ModalNewEntradaCliente').val();
    
        // Verificar si se ha seleccionado un cliente en la modal
        if (!ModalNewEntradaCliente) {
            // Si no se ha seleccionado ningún cliente, emitir un SweetAlert
            swal({
                icon: 'error',
                title: 'Oops...',
                text: 'Debes seleccionar un cliente primero',
            });
        } else {
            // Si se ha seleccionado un cliente, abrir la modal de CargarProductoEntrada
            $.post( "acciones.php", { loadproductoscliente: ModalNewEntradaCliente })
              .done(function( data ) {
                  $('#ModalAddProductoEntrada .modal-body').html(data);
               
              });
            $('#ModalAddProductoEntrada').modal('show');
        }
    }
     
    function ubicar(identrada) {
        $.post( "acciones.php", { identrada: identrada })
          .done(function( data ) {
              $('#ModalZone .modal-body').html(data);
           
          });
        $('#ModalZone').modal('show');
    }
    
    function showImage(imageUrl) {
       window.open(imageUrl,'name','height=600,width=320'); 
	    window.focus();
    }
    function imprimir(id){
	    window.open('imprimir.php?code='+id,'imprimir guia','height=600,width=320'); 
	    window.focus;
	    return false; 
    }
    
    function uploadSoporte() {
        var form = document.getElementById('uploadForm');
        var formData = new FormData(form);
        
        var xhr = new XMLHttpRequest();
        xhr.open('POST', 'acciones.php', true);
        xhr.onload = function() {
            if (xhr.status === 200) {
                // Handle successful upload
                form.reset(); // Restablecer el formulario
                $('#dataTable').DataTable().ajax.reload();
                $('#ModalLoadFile').modal('hide');
                var response = JSON.parse(xhr.responseText); // Parsear la respuesta JSON
                swal(response.message);
            } else {
                // Handle upload error
                swal('Error during upload: ' + xhr.status);
            }
        };
        xhr.onerror = function() {
            // Handle network error
            console.error('Network error during upload');
        };
        xhr.send(formData);
    }
    
    function loadserial(element) {
        var serial = $(element).val();
        var error = 0; // Declarar la variable error fuera del bucle
    
        // Recorre todos los inputs con la clase .serial-input
        $('input[name="seriales[]"]').each(function() {
            var valorActual = $(this).val().trim();
            if (valorActual === serial) {
                error = 1; // Establece error en 1 si se encuentra un valor duplicado
                return false; // Sal del bucle si se encuentra un valor duplicado
            }
        });
    
        // Verifica si se encontró un valor duplicado
        if (error) {
            $(element).val('');
            swal('¡El serial ingresado ya se encuentra añadido!');
        } else {
            // Agrega el nuevo serial al contenedor #seriales
            $('#seriales').append('<div class="serial"><input type="text" name="seriales[]" value="' + serial + '" readonly><i onclick="eliminarserial(this)" class="fa fa-trash"></i></div>');
            $(element).val(''); // Limpia el input después de agregar el serial
        }
    };
    
    function eliminarserial(elemento) {
        // Obtener el elemento padre del ícono
        var divPadre = elemento.parentNode;
        
        // Eliminar el elemento padre
        divPadre.remove();
    }

    $(document).ready(function(){
        // ...
    
        // Agrega esta función para recargar la tabla al cambiar el valor del select
        $('#cliente').change(function(){
          var selectedPerfil = $(this).val();
    
          // Agrega la condición deseada según el valor seleccionado
          var ajaxUrl = selectedPerfil !== 'Todos' ? 'server_side/entradas.php?cliente=' + selectedPerfil : 'server_side/entradas.php';
    
          // Recarga la tabla con la nueva URL
          $('#dataTable').DataTable().ajax.url(ajaxUrl).load();
        });
        
        $('#newformulario').submit(function(e) {
            e.preventDefault();
            var action = $(this).attr('action');
            var method = $(this).attr('method');
            var formData = new FormData($(this)[0]); // Crea un objeto FormData con el formulario
            $.ajax({
                url: action,
                type: method,
                data: formData,
                dataType: 'json',
                processData: false,  // No proceses los datos (FormData lo manejará)
                contentType: false,  // No establezcas el tipo de contenido (FormData lo manejará)
                success: function(response) {
                    if (response.success) {
                        
                        $('#intable tbody').html('<tr id="sindata" class="odd"><td valign="top" colspan="6" class="dataTables_empty text-center">No hay productos cargados</td></tr>');
                        $('#newformulario').trigger('reset');
                        $('#newformulario').find('.chosen-select').val('').trigger('chosen:updated');
                        $('#dataTable').DataTable().ajax.reload();
                        swal(response.message);
                    } else {
                        // Si la solicitud fue exitosa pero se recibe un mensaje de error
                        // Mostrar un mensaje de error en algún lugar del formulario
                        swal(response.message);
                    }
                },
                error: function(xhr, status, error) {
                    // Manejar los errores de la solicitud AJAX
                    console.error('Error en la solicitud AJAX:', error);
                }
            })
        });
        
        $('#modalZone').submit(function(e) {
            e.preventDefault();
            var action = $(this).attr('action');
            var method = $(this).attr('method');
            var formData = $(this).serialize();
            $.ajax({
                url: action,
                type: method,
                data: formData,
                dataType: 'json'
            })
            .done(function(response) {
                if (response.success) {
                    $('#dataTable').DataTable().ajax.reload();
                    $('#ModalZone').modal('hide');
                    swal(response.message);
                } else {
                    swal(response.message);
                }
            })
            .fail(function(xhr, status, error) {
                // Si la solicitud falla, manejar el error aquí
                console.error("Error en la solicitud AJAX:", status, error);
            });
        });
        
        $(document).on('change', 'select[name^="addzonaubicacion["]', function() {
             
            let nameAttr = $(this).attr('name');
            let id = nameAttr.match(/\[(\d+)\]/)[1];
              $.post( "acciones.php", { 
                 listgondolazona: $(this).val() 
            }).done(function( response ) {
                $('select[name^="addgondolaubicacion['+id+']').html(response);
                $.post( "acciones.php", { 
                     listanaquelgondola: $('select[name^="addgondolaubicacion['+id+']').val() 
                }).done(function( response ) {
                    $('select[name^="addanaquelubicacion['+id+']').html(response);
                });  
            });
        });
        
        $(document).on('change', 'select[name^="addgondolaubicacion["]', function() {
             
            let nameAttr = $(this).attr('name');
            let id = nameAttr.match(/\[(\d+)\]/)[1];
            $.post( "acciones.php", { 
                 listanaquelgondola: $(this).val() 
            }).done(function( response ) {
                $('select[name^="addanaquelubicacion['+id+']').html(response);
            });  
        });
  });
  </script>
</body>
</html>   