<?php
$r= '../';
$titlepage = "Gestion Database Clientes";
require_once($r."inc/config.php");
validSession($r);
$mysqli = connectDB($r);
$spe = $_SESSION['perfil'];
$idusuario = $_SESSION['userid'];
roleaccess(410);
include $r."inc/head.php"; ?>

<body class="fixed-nav sticky-footer sidenav-toggled bg-dark" id="page-top">
    <?php include $r."inc/nav.php"; ?>
 
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="card mb-3">
                <div class="h3 card-header">
                    <i class="fa fa-list"></i> Lista de Brochures
                    <i class="btn text-primary fa fa-upload float-right" aria-hidden="true" data-toggle="modal" data-target="#upload"></i>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-striped" id="dataTableLista" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                              <th>Nombre</th>
                              <th>Descripcion</th>
                              <th style="max-width: 120px;"><i class="fa fa-gear"></i></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>


    
    <style>
    .chosen-container {
        width: 100%!important;
    }
    .nav-tabs .nav-link.active {
        background: #0056b3;
        color: #fff;
        border-color: unset;
    }
    @media (min-width: 1140px) {
        .modal-lg {
            max-width: 1000px; /* Ancho del modal para pantallas grandes */
        }
    }
    </style>
    
     <!-- Modal Acciones -->
    <div class="modal fade" id="upload" tabindex="-1" aria-labelledby="accionesLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="accionesLabel">Cargar Brochure</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="container">
                        <form class="newform" id="form-upload-brochure" method="POST" action="acciones.php" enctype="multipart/form-data">
                            <div class="form-group">
                                <label for="nombre_archivo">Nombre del Archivo</label>
                                <input type="text" class="form-control" id="nombre_archivo" name="nombre_archivo" required>
                            </div>
                            <div class="form-group">
                                <label for="descripcion_archivo">Descripción</label>
                                <textarea class="form-control" id="descripcion_archivo" name="descripcion_archivo" rows="3" required></textarea>
                            </div>
                            <div class="form-group">
                                <label for="brochure">Seleccionar Brochure (PDF)</label>
                                <input type="file" class="form-control-file" id="brochure" name="brochure" accept="application/pdf" required>
                            </div>
                        </form>
                        <!-- Botones -->
                        <div class="text-right mt-4">
                            <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
                            <button class="btn btn-primary" type="submit" form="form-upload-brochure">CARGAR</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
  <?php include $r."inc/foot.php"; ?>
  
  <script>
    // Inicialización de DataTable
    function initDataTable(tableId, ajaxUrl, selectEstado) {
        return $('#' + tableId).DataTable({
            "order": [[0, 'desc']],
            "ordering": true,
            "processing": true,
            "serverSide": true,
            "stateSave": true, // Guarda el estado (paginación, búsqueda, filtros)
            "ajax": {
                "url": ajaxUrl,
                "data": function(d) {
                    d.tbestado = $('#'+selectEstado).val();
                }
            },
            "dom": 'lfBtipr',
            "buttons": [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    }

    var dataTableLista = initDataTable('dataTableLista', 'server_side/brochures.php', 'ebrochures');
    
    function verbrochure(ruta) {
        const urlAbsoluta = window.location.origin + '/app/brochures/uploads/' + ruta.replace(/^\/+/, '');
        const urlGoogle = 'https://docs.google.com/viewer?url=' + encodeURIComponent(urlAbsoluta) + '&embedded=true';
        const ventana = window.open(urlGoogle, '_blank', 'toolbar=0,location=0,menubar=0,scrollbars=1,resizable=1,width=800,height=600');
        if (ventana) {
            ventana.focus();
        }
    }

    function delbrochure(idtabla) {
        swal({
            title: "¿Estás seguro?",
            text: "Esta acción eliminará el brochure permanentemente.",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            cancelButtonColor: "#3085d6",
            confirmButtonText: "Sí, eliminar",
            cancelButtonText: "Cancelar"
        }, function(confirmado) {
            if (confirmado) {
                $.post("acciones.php", { accion: "eliminar_brochure", id: idtabla }, function(response) {
                    swal("Eliminado", response.message, "success");
                    if (response.hasOwnProperty('table') && Array.isArray(response.table)) { 
                    $(response.table).each(function(index, tableId) {
                            $(tableId).DataTable().ajax.reload(null, false);
                        });
                    }
                    if (response.hasOwnProperty('modal') && response.modal === true) { 
                        $(".modal").modal('hide'); 
                    }
                }).fail(function() {
                    swal("Error", "No se pudo eliminar el brochure.", "error");
                });
            }
        });
    }



    $(document).ready(function() {
    
        // Evento para actualizar la tabla cuando cambia el filtro
        $('#edatos').change(function() {
            dataTableLista.ajax.reload();
        });
        $('#ellamadas').change(function() {
            dataTableLlamadas.ajax.reload();
        });
        $('#ecitas').change(function() {
            dataTableCitas.ajax.reload();
        });
        
        $(".chosen-select").chosen({disable_search_threshold: 10});
        
        $('.newform').submit(function(e) {
            e.preventDefault();
        
            // Desactivar el botón de submit
            let submitButton = $("button[type=submit]");
            $("button[type=submit]").prop("disabled", true);
            
            // Mostrar alerta de espera
            swal({
                title: "Espere un momento...",
                text: "Procesando su solicitud",
                icon: "info",
                buttons: false,
                closeOnClickOutside: false,
                closeOnEsc: false
            });
        
            var action = $(this).attr('action');
            var formData = new FormData(this);
        
            $.ajax({
                url: action,
                type: "post",
                dataType: 'json', // Se cambió a JSON para mejor manejo de respuesta
                data: formData,
                contentType: false,  // Deshabilitar el tipo de contenido predeterminado
                processData: false,  // Deshabilitar el procesamiento automático de los datos
                timeout: 10000, // 10 segundos de tiempo límite
        
                success: function(response) {
                    submitButton.prop("disabled", false); // Habilitar botón
        
                    if (response.success) {
                        swal("Completado", response.message || "El proceso ha finalizado correctamente.", "success");
                        if (response.hasOwnProperty('table') && Array.isArray(response.table)) { 
                            $(response.table).each(function(index, tableId) {
                                $(tableId).DataTable().ajax.reload(null, false);
                            });
                        }
                        if (response.hasOwnProperty('modal') && response.modal === true) { 
                            $(".modal").modal('hide'); 
                        }
                        // LIMPIAR FORMULARIO
                        $('.newform')[0].reset(); // Resetear el formulario completo
                        $(".newform select").val("").trigger("chosen:updated"); // Limpiar selects Chosen
                        $(".newform input[type=checkbox], .newform input[type=radio]").prop("checked", false); // Limpiar checkboxes y radios
              
                        
                    } else {
                        swal("Error", response.message || "Hubo un problema con la solicitud.", "error");
                    }
                },
        
                error: function(xhr, status, error) {
                    submitButton.prop("disabled", false); // Habilitar botón
        
                    let errorMessage = "Error desconocido, inténtelo de nuevo.";
                    if (status === "timeout") {
                        errorMessage = "El servidor tardó demasiado en responder.";
                    } else if (xhr.status === 500) {
                        errorMessage = "Error interno del servidor (500).";
                    } else if (xhr.status === 404) {
                        errorMessage = "La URL de destino no fue encontrada (404).";
                    } else if (xhr.responseText) {
                        errorMessage = xhr.responseText;
                    }
        
                    swal("Fallo en la conexión", errorMessage, "error");
                }
            });
        });
    });
  </script>
</body>
</html>   