<?php
header('Content-Type: application/json');

// Simulación de estados reales desde la tabla que mostraste
$estadosOficiales = [
  "Por Asignar", "Por Confirmar", "Por Realizar", "Completada",
  "Cancelada", "Reprogramada", "No Realizada",
  "No Contesto", "Rechazada", "Fidelizado"
];

$data = [
  'agentes' => [],
  'estados' => [],
  'diario' => []
];

// Simular llamadas por agente
$agentes = ["Juan", "Ana", "Carlos", "Luisa"];
foreach ($agentes as $nombre) {
    $data['agentes'][] = [
        'nombre' => $nombre,
        'total' => rand(50, 120)
    ];
}

// Simular estados
foreach ($estadosOficiales as $estado) {
    $data['estados'][] = [
        'estado' => $estado,
        'total' => rand(5, 40)
    ];
}

// Simular llamadas por día
$hoy = strtotime(date('Y-m-d'));
for ($i = 6; $i >= 0; $i--) {
    $fecha = date('Y-m-d', strtotime("-$i days", $hoy));
    $data['diario'][] = [
        'fecha' => $fecha,
        'total' => rand(30, 90)
    ];
}

echo json_encode($data);
