<?php
$r= '../';
$titlepage = "Gestion Database Clientes";
require_once($r."inc/config.php");
validSession($r);
$mysqli = connectDB($r);
$spe = $_SESSION['perfil'];
$idusuario = $_SESSION['userid'];
roleaccess(600);
include $r."inc/head.php"; ?>

<body class="fixed-nav sticky-footer sidenav-toggled bg-dark" id="page-top">
    <?php include $r."inc/nav.php"; ?>
 
    <div class="content-wrapper">
        <div class="container-fluid">
            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active h4" id="lista-tab" data-toggle="tab" href="#lista" role="tab"><i class="fa fa-list"></i> Lista de Datos</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link h4" id="llamadas-tab" data-toggle="tab" href="#llamadas" role="tab"><i class="fa fa-phone"></i> Llamadas Programadas</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link h4" id="citas-tab" data-toggle="tab" href="#citas" role="tab"><i class="fa fa-calendar"></i> Citas Programadas</a>
                </li>
                <button title=" Subir Archivo CSV" type="button" class="btn btn-info" data-toggle="modal" data-target="#modalSubirArchivo"  style="    position: absolute;    right: 20px;">    <i class="fa fa-upload"></i></button>
                <a class="btn btn-primary" href="download_data.php"  style="    position: absolute;    right: 70px;">    <i class="fa fa-download"></i></a>
                <a class="btn btn-secondary" href="ciiu.php"  style="    position: absolute;    right: 120px;">    <i class="fa fa-list"></i></a>
            </ul>
            
            <div class="tab-content mt-3" id="myTabContent">
                <div class="tab-pane fade show active" id="lista" role="tabpanel">
                    <div class="card mb-3">
                        <div class="h3 card-header">
                            <i class="fa fa-list"></i> Lista de Datos
                            <select id="edatos" class="form-control col-sm-3 float-right">
                              <?php $qry1 = $mysqli->query("SELECT * FROM call_data_estados"); while($row1 = $qry1->fetch_assoc()){ ?>
                                <option value="<?= $row1['id']; ?>"><?= $row1['label']; ?></option>
                              <? } ?>
                              <option value="todos">Todos</option>
                          </select>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered table-striped" id="dataTableLista" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                      <th>ID</th>
                                      <th>Empresa</th>
                                      <th>Correo</th>
                                      <th>Sector</th>
                                      <th>Direccion</th>
                                      <th>Contacto</th>
                                      <th>Telefono</th>
                                      <th>Estado</th>
                                      <th>Asesor</th>
                                      <th style="max-width: 120px;"><i class="fa fa-gear"></i></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="llamadas" role="tabpanel">
                    <div class="card mb-3">
                        <div class="h3 card-header">
                            <i class="fa fa-phone"></i> Llamadas Programadas
                            <select id="ellamadas" class="form-control col-sm-3 float-right">
                              <?php $qry1 = $mysqli->query("SELECT * FROM call_data_llamadas_estados"); while($row1 = $qry1->fetch_assoc()){ ?>
                                <option value="<?= $row1['id']; ?>"><?= $row1['estado']; ?></option>
                              <? } ?>
                              <option value="todos" selected>Todos</option>
                          </select>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered table-striped" id="dataTableLlamadas" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Empresa</th>
                                        <th>Fecha</th>
                                        <th>Usuario</th>
                                        <th>Estado</th>
                                        <th><i class="fa fa-gear"></i></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="citas" role="tabpanel">
                    <div class="card mb-3">
                        <div class="h3 card-header">
                            <i class="fa fa-calendar"></i> Citas Programadas
                            <select id="ecitas" class="form-control col-sm-3 float-right">
                              <?php $qry1 = $mysqli->query("SELECT * FROM call_data_visitas_estados"); while($row1 = $qry1->fetch_assoc()){ ?>
                                <option value="<?= $row1['id']; ?>"><?= $row1['estado']; ?></option>
                              <? } ?>
                              <option value="todos" selected>Todos</option>
                          </select>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered table-striped" id="dataTableCitas" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                      <th>ID</th>
                                      <th>Empresa</th>
                                      <th>Tipo</th>
                                      <th>Fecha</th>
                                      <th>Servicio</th>
                                      <th>Usuario</th>
                                      <th>Estado</th>
                                      <th style="max-width: 120px;"><i class="fa fa-gear"></i></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<!-- Modal -->
<div class="modal fade" id="modalSubirArchivo" tabindex="-1" role="dialog" aria-labelledby="modalSubirArchivoLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalSubirArchivoLabel">Subir Archivo CSV</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Formulario -->
                <form class="newform"  action="acciones.php" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="csv" value="true">
                    <div class="col-md-12">
                        <div class="form-group">
                            <select name="accion" class="form-control" required>
                                <option value="1" selected>Importar</option>
                                <option value="2" selected>Actualizar</option>
                            </select>
                            <small class="form-text text-muted" onclick="infocsv()" style="cursor:pointer">
                                Haz clic en <i class="fa fa-question-circle text-info fa-2x"></i> para ver el formato requerido del archivo CSV.
                            </small>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="archivo">Selecciona el archivo CSV:</label>
                            <input type="file" class="form-control" name="archivo" id="archivo" accept=".csv" required>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="asesor">Selecciona un Asesor:</label>
                        <select name="asesor" id="asesor" class="chosen-select" required>
                            <option value="" selected disabled>Seleccione el Asesor...</option>
                            <?php  
                            $qry1 = $mysqli->query("SELECT * FROM z_usuarios WHERE perfil IN (5, 6,8) ORDER BY id ASC"); 
                            while ($row1 = $qry1->fetch_assoc()) {  
                                echo '<option value="' . $row1['id'] . '">' . strtoupper($row1['nombre']) . '</option>';  
                            }  
                            ?>
                        </select>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">Subir Archivo</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<button data-toggle="modal" data-target="#listfidelizados" id="btnTelefono" style="
  position: fixed;
  bottom: 20px;
  right: 20px;
  z-index: 800;
  background-color: #007bff;
  color: white;
  border: none;
  border-radius: 50%;
  width: 60px;
  height: 60px;
  box-shadow: 0 4px 6px rgba(0,0,0,0.2);
  font-size: 24px;
  cursor: pointer;
">
 <i class="fa fa-phone"></i>
</button>
    
    <style>
    .chosen-container {
        width: 100%!important;
    }
    .nav-tabs .nav-link.active {
        background: #0056b3;
        color: #fff;
        border-color: unset;
    }
    @media (min-width: 1140px) {
        .modal-lg {
            max-width: 1000px; /* Ancho del modal para pantallas grandes */
        }
    }
    </style>
    
    <!-- Modal Asignar Asesor -->
    <div class="modal" id="listfidelizados" tabindex="-1">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Asignar Agente</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
                <table class="table table-bordered table-striped" id="dataTableFidelizados" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                          <th>Empresa</th>
                          <th>Correo</th>
                          <th>Direccion</th>
                          <th>Contacto</th>
                          <th>Telefono</th>
                          <th>Tipo</th>
                          <th>Dias</th>
                        </tr>
                    </thead>
                </table>
            </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
          </div>
        </div>
      </div>
    </div>
    
     <!-- Modal Acciones -->
    <div class="modal fade" id="acciones" tabindex="-1" aria-labelledby="accionesLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="accionesLabel">Acciones de LLamada</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <h5 class="text-center mb-3">Información del Cliente</h5>
                    <div class="container">
                        <form class="newform" id="form-cliente" method="POST" action="acciones.php">
                            <input type="hidden" name="iddatacliente" value="">
                            
                            <div class="row">
                                <!-- Primera Columna -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="empresa">Empresa</label>
                                        <input type="text" class="form-control" id="empresa" name="empresa" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="contacto">Contacto</label>
                                        <input type="text" class="form-control" id="contacto" name="contacto">
                                    </div>
                                </div>
                
                                <!-- Segunda Columna -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="correo">Correo</label>
                                        <input type="email" class="form-control" id="correo" name="correo" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="telefono">Teléfono</label>
                                        <input type="tel" class="form-control" id="telefono" name="telefono" required>
                                    </div>
                                </div>
                
                                <!-- Tercera Columna -->
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Sector Económico</label>
                                        <select name="sectores[]" class="chosen-select form-control" data-placeholder="Seleccione CIIU ..." multiple>
                                            <?php $qry1 = $mysqli->query("SELECT * FROM call_data_sectores_economico ORDER BY sector ASC"); 
                                            while($row1 = $qry1->fetch_assoc()){ ?>
                                                <option value="<?= $row1['id']; ?>">
                                                    <?= substr('000'.$row1['id'],-4).' '. $row1['sector']; ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="direccion">Dirección</label>
                                        <input type="text" class="form-control" id="direccion" name="direccion">
                                    </div>
                                </div>
                                <hr>
                                <!-- Opciones Adicionales -->
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Enviar Brochure</label>
                                        <select form="form-cliente" name="brochure[]" data-placeholder="Seleccione brochure ..." class="chosen-select form-control" multiple>
                                            <?php $qry1 = $mysqli->query("SELECT * FROM call_brochures"); 
                                            while($row1 = $qry1->fetch_assoc()){ ?>
                                                <option value="<?= $row1['ruta']; ?>" title="<?= $row1['descripcion']; ?>">
                                                    <?= $row1['nombre']; ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Acción Llamada</label>
                                        <select form="form-cliente" name="accion" class="form-control" required>
                                            <option value="" selected disabled>Seleccione una acción...</option>
                                            <?php $qry1 = $mysqli->query("SELECT * FROM call_data_estados WHERE id!=0 ORDER BY id ASC"); 
                                            while($row1 = $qry1->fetch_assoc()){ ?>
                                                <option value="<?= $row1['id']; ?>" title="<?= $row1['descripcion']; ?>">
                                                    <?= $row1['label']; ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div id="select-acciones"></div>
                        
                        <!-- Botones -->
                        <div class="text-right mt-4">
                            <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
                            <button class="btn btn-primary" type="submit" form="form-cliente">Finalizar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
    
                
   <!-- Modal Asignar Asesor -->
    <div class="modal" id="asignar" tabindex="-1">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Asignar Agente</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
                <form id="form-asignar-agente" class="newform" method="POST" action="acciones.php">
                    <input type="hidden" name="idevent">
                    <input type="hidden" name="tipoevent">
            
                    <div class="form-group">
                        <label for="asesor">Asesor a Asignar</label>
                        <select name="asesor" id="asesor" class="chosen-select" required>
                            <option value="" selected disabled>Seleccione el Asesor...</option>
                            <?php  
                            $qry1 = $mysqli->query("SELECT * FROM z_usuarios WHERE perfil IN (5, 6, 8) ORDER BY id ASC"); 
                            while ($row1 = $qry1->fetch_assoc()) {  
                                echo '<option value="' . $row1['id'] . '">' . strtoupper($row1['nombre']) . '</option>';  
                            }  
                            ?>
                        </select>
                    </div>
                </form>
            </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
            <button type="submit" class="btn btn-primary" form="form-asignar-agente">Asignar</button>
          </div>
        </div>
      </div>
    </div>
    
    
    <!-- Modal Cita -->
    <div class="modal fade" id="reagendar" tabindex="-1" aria-labelledby="citaLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="labelreagendar">Reagendar <span></span></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="form-reagendar" class="newform" method="POST" action="acciones.php">
                        <input type="hidden" name="reagendaridevent">
                        <input type="hidden" name="reagendartipoevent">
                        <div class="form-group">
                            <label for="fecha-cita">Fecha</label>
                            <input type="date" class="form-control" id="fecha-cita" name="fecha_cita" required>
                        </div>
                
                        <div class="form-group">
                            <label for="hora-cita">Hora</label>
                            <input type="time" class="form-control" id="hora-cita" name="hora_cita" required>
                        </div>
                
                        <div class="form-group">
                            <label for="nota-cita">Nota Adicional</label>
                            <textarea class="form-control" id="nota-cita" name="nota_cita" rows="3"></textarea>
                        </div>
                    </form>
                </div>


                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary" form="form-reagendar">Reagendar</button>
                </div>
            </div>
        </div>
    </div>
    
    
    <!-- Modal llamada -->
    <div class="modal fade" id="finalizar" tabindex="-1" aria-labelledby="llamadaLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="llamadaLabel">Actualizar Estado</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="form-finalizar" class="newform" method="POST" action="acciones.php">
                    <div class="modal-body" id="body-finalizar">
                    </div>
                </form>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary" form="form-finalizar">Finalizar</button>
                </div>
            </div>
        </div>
    </div>
    
    
     <!-- Modal fidelizar -->
    <div class="modal fade" id="fidelizar" tabindex="-1" aria-labelledby="llamadaLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="llamadaLabel">Seleccionar Día Ideal de Llamada</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="form-fidelizar" class="newform" method="POST" action="acciones.php">
                    <input type="hidden" name="iddatafidelizar">
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Selecciona el tipo de preferencia</label>
                            <select class="form-control" id="tipo-seleccion" name="tipo_seleccion" required>
                                <option value="">-- Selecciona --</option>
                                <option value="semana">Días de la Semana</option>
                                <option value="mes">Días del Mes</option>
                            </select>
                        </div>
    
                        <div class="form-group" id="grupo-semana" style="display: none;">
                            <label>Días de la Semana</label>
                            <div class="form-check">
                                <label><input class="form-check-input" type="checkbox" name="dias_semana[]" value="Lunes"> Lunes</label><br>
                                <label><input class="form-check-input" type="checkbox" name="dias_semana[]" value="Martes"> Martes</label><br>
                                <label><input class="form-check-input" type="checkbox" name="dias_semana[]" value="Miércoles"> Miércoles</label><br>
                                <label><input class="form-check-input" type="checkbox" name="dias_semana[]" value="Jueves"> Jueves</label><br>
                                <label><input class="form-check-input" type="checkbox" name="dias_semana[]" value="Viernes"> Viernes</label><br>
                                <label><input class="form-check-input" type="checkbox" name="dias_semana[]" value="Sábado"> Sábado</label><br>
                                <label><input class="form-check-input" type="checkbox" name="dias_semana[]" value="Domingo"> Domingo</label>
                            </div>
                        </div>
    
                        <div class="form-group" id="grupo-mes" style="display: none;">
                            <label>Días del Mes</label>
                            <select class="form-control" name="dias_mes[]" multiple size="5">
                                <?php for ($i = 1; $i <= 31; $i++): ?>
                                    <option value="<?= $i ?>"><?= $i ?></option>
                                <?php endfor; ?>
                            </select>
                            <small class="form-text text-muted">Mantén presionada Ctrl (Windows) o Cmd (Mac) para seleccionar varios.</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
                        <button type="submit" class="btn btn-primary" form="form-fidelizar">Finalizar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
   <!-- Modal Evniar Brochuew -->
    <div class="modal" id="sendbrochure" tabindex="-1">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Enviar Brochuere</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
                <form id="form-send-brochure" class="newform" method="POST" action="acciones.php">
                    <input type="hidden" name="iddatabrochure">
            
                    <div class="form-group">
                        <label>Enviar Brochure</label>
                        <select name="brochure[]" data-placeholder="Seleccione brochure ..." class="chosen-select form-control" multiple>
                            <?php $qry1 = $mysqli->query("SELECT * FROM call_brochures"); 
                            while($row1 = $qry1->fetch_assoc()){ ?>
                                <option value="<?= $row1['id']; ?>" title="<?= $row1['descripcion']; ?>">
                                    <?= $row1['nombre']; ?>
                                </option>
                            <?php } ?>
                        </select>
                    </div>
                </form>
            </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
            <button type="submit" class="btn btn-primary" form="form-send-brochure">Enviar</button>
          </div>
        </div>
      </div>
    </div>
    
   <!-- Modal Evniar Brochuew -->
    <div class="modal" id="modal_tarea" tabindex="-1">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Informacion</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <form class="modal-body newform" id="body-tarea" method="POST" action="acciones.php">
          </form>
        </div>
      </div>
    </div>
    
  <?php include $r."inc/foot.php"; ?>
  
  <script>
    // Inicialización de DataTable
    function initDataTable(tableId, ajaxUrl, selectEstado) {
        return $('#' + tableId).DataTable({
            "order": [[0, 'desc']],
            "ordering": true,
            "processing": true,
            "serverSide": true,
            "stateSave": true, // Guarda el estado (paginación, búsqueda, filtros)
            "ajax": {
                "url": ajaxUrl,
                "data": function(d) {
                    d.tbestado = $('#'+selectEstado).val();
                }
            },
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
            "dom": 'lfBtipr',
            "buttons": [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    }

    var dataTableLista = initDataTable('dataTableLista', 'server_side/data_clientes.php', 'edatos');
    var dataTableLlamadas = initDataTable('dataTableLlamadas', 'server_side/data_llamadas.php' ,'ellamadas');
    var dataTableCitas = initDataTable('dataTableCitas', 'server_side/data_citas.php','ecitas');
    var dataTableFidelizados = initDataTable('dataTableFidelizados', 'server_side/data_fidelizados.php','efidelizados');
    
    
    function acciones(id){
        $.post( "acciones.php", { infodatacliente: id })
          .done(function( response ) {
            if (response.success) {
                let data = JSON.parse(response.message);
                $('input[name=iddatacliente]').val(data.id);
                $('input[name=empresa]').val(data.empresa);
                $('input[name=correo]').val(data.correo);
                $('select[name="sectores[]"]').val(data.sector_economico).trigger("chosen:updated");
                $('input[name=direccion]').val(data.direccion);
                $('input[name=contacto]').val(data.contacto);
                $('input[name=telefono]').val(data.telefono);
                $('#select-acciones').html('');
                $('#acciones').modal('show');
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                swal(response.message);
            }
        });
    }
    
    function sendmail(id){
        $('#form-send-brochure')[0].reset();
        $("#form-send-brochure select").val("").trigger("chosen:updated"); // Limpiar selects Chosen
        $('input[name=iddatabrochure]').val(id);
        $('#sendbrochure').modal('show');
    }
    
    function asignar(id, tipo){
        $('select[name=asesor]').val();
        $('input[name=idevent]').val(id);
        $('input[name=tipoevent]').val(tipo);
        $('#asignar').modal('show');
    }
    
    function reagendar(id, tipo){
        $('#labelreagendar span').html(tipo);
        $('input[name=reagendaridevent]').val(id);
        $('input[name=reagendartipoevent]').val(tipo);
        $('#reagendar').modal('show');   
    }
    
    function finalizada(id,tipo){
        $('#finalizar').modal('show');
        $.post('acciones.php', { idendevent: id, tipo: tipo }, function(data) {
            $('#body-finalizar').html(data);
        });
    }
    
    function decisionTarea(id, tipo) {
        $('#body-tarea').html('');
        $.post("acciones.php", { info_tarea: id, tipo: tipo}, function(response) {
            if (response.success) {
                
                $('#body-tarea').html(response.message);
                $('#modal_tarea').modal('show');
            } else {
                swal("Error", "Hubo un problema al procesar la " + tipo + ".", "error");
            }
        }, "json").fail(function() {
            swal("Error", "No se pudo conectar con el servidor.", "error");
        });
    }
    
    function linkevent(id, tipo) {
        fetch('acciones.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: `obtenerevento=${encodeURIComponent(id)}&tipo=${encodeURIComponent(tipo)}`
        })
        .then(response => response.json())
        .then(data => {
            if (!data || data.error) {
                alert("No se pudo obtener la información del evento.");
                return;
            }
    
            const { nombre, telefono, fecha, hora, ubicacion, correo, modalidad } = data;
    
            let titulo = "";
            let descripcion = "";
            let location = "";
            let mensajeWhatsapp = "";
    
            if (tipo === 'llamada') {
                titulo = `Llamada con ${nombre}`;
                descripcion = `Llamar al cliente ${nombre} (${telefono})`;
                location = "Teléfono";
                mensajeWhatsapp = `Hola ${nombre}, te llamaremos el ${fecha} a las ${hora}.`;
            } else if (tipo === 'cita') {
                if (modalidad === 'Virtual') {
                    titulo = `Reunión Virtual con ${nombre}`;
                    descripcion = `Reunión virtual con ${nombre}. Enlace: ${ubicacion}`;
                    location = ubicacion;
                    mensajeWhatsapp = `Hola ${nombre}, agendamos una reunión virtual para el ${fecha} a las ${hora}. Aquí está el enlace: ${ubicacion}`;
                } else if (modalidad === 'Presencial') {
                    titulo = `Reunión Presencial con ${nombre}`;
                    descripcion = `Reunión presencial con ${nombre} en ${ubicacion}`;
                    location = ubicacion;
                    mensajeWhatsapp = `Hola ${nombre}, nos reuniremos presencialmente el ${fecha} a las ${hora} en: ${ubicacion}`;
                } else {
                    alert("Modalidad de cita no válida.");
                    return;
                }
            } else {
                alert("Tipo de evento no válido.");
                return;
            }
    
            // Construcción de fechas
            const start = new Date(`${fecha}T${hora}`);
            const end = new Date(start.getTime() + 30 * 60000);
    
            const startStr = start.toISOString().replace(/-|:|\.\d+/g, "");
            const endStr = end.toISOString().replace(/-|:|\.\d+/g, "");
    
            // URL de Google Calendar
            const calendarUrl = `https://calendar.google.com/calendar/render?action=TEMPLATE`
                + `&text=${encodeURIComponent(titulo)}`
                + `&dates=${startStr}/${endStr}`
                + `&details=${encodeURIComponent(descripcion)}`
                + `&location=${encodeURIComponent(location)}`
                + `&add=${encodeURIComponent(correo)}`
                + `&invite=${encodeURIComponent(correo)}`;
    
            // WhatsApp
            const whatsappUrl = `https://wa.me/${telefono}?text=${encodeURIComponent(mensajeWhatsapp)}`;
    
            mostrarModalOpciones(calendarUrl, whatsappUrl);
        })
        .catch(error => {
            console.error('Error:', error);
            alert("Ocurrió un error al obtener los datos del evento.");
        });
    }


    function responderTarea(id, tipo, accion) {
        if (accion === 'rechazar') {
                $('#body-tarea').html('<label for="motivo-rechazo" style="font-weight:bold; display:block; margin-bottom:5px;">Motivo del rechazo:</label><input type="hidden" name="procesar_tarea" value="rechazar"><input type="hidden" name="id" value="'+id+'"><input type="hidden" name="tipo"  value="'+tipo+'"><textarea name="motivo_rechazo" placeholder="Escribe el motivo..." class="form-control" required style="width:100%; padding:8px; margin-bottom:10px;"></textarea>                    <button type="submit" class="btn btn-danger" form="body-tarea">Rechazar</button>                ');
        } else {
            // Acción de aceptar directamente
            $.post('acciones.php', {
                id: id,
                tipo: tipo,
                procesar_tarea: 'aceptar'
            }, function (response) {
                if (response.success) {
                    swal("Aceptado", response.message , "success");
                    if (response.hasOwnProperty('table') && Array.isArray(response.table)) { 
                            $(response.table).each(function(index, tableId) {
                                $(tableId).DataTable().ajax.reload(null, false);
                            });
                        }
                    $('#modal_tarea').modal('hide');
                } else {
                    swal("Error", response.message, "error");
                }
            }, 'json');
        }
    }
    
    function fidelizar(id,tipo) {
        $('input[name=iddatafidelizar]').val(id);
        $('#fidelizar').modal('show');
    }
    
    function mostrarModalOpciones(calendarUrl, whatsappUrl) {
        // Elimina cualquier modal anterior
        $('#modalOpcionesEvento').remove();
    
        // Modal HTML dinámico
        const modalHtml = `
        <div id="modalOpcionesEvento" style="position:fixed; top:0; left:0; width:100%; height:100%; 
            background-color:rgba(0,0,0,0.6); z-index:9999; display:flex; align-items:center; justify-content:center;">
            <div style="background:#fff; padding:20px; border-radius:10px; max-width:400px; width:100%; position:relative; text-align:center;">
                <span id="cerrarModalEvento" style="position:absolute; top:10px; right:15px; cursor:pointer; font-weight:bold;">&times;</span>
                <h3>Compartir evento</h3>
                <p>¿Qué deseas hacer?</p>
                <div style="margin-top:20px;">
                    <button id="btnGoogleCalendar" style="margin:5px; padding:10px 20px;" class="btn btn-primary">
                        Google Calendar
                    </button>
                    <button id="btnWhatsApp" style="margin:5px; padding:10px 20px;" class="btn btn-success">
                        WhatsApp
                    </button>
                </div>
            </div>
        </div>`;
    
        $('body').append(modalHtml);
    
        // Eventos de los botones
        $('#btnGoogleCalendar').on('click', function() {
            window.open(calendarUrl, '_blank');
            $('#modalOpcionesEvento').remove();
        });
    
        $('#btnWhatsApp').on('click', function() {
            window.open(whatsappUrl, '_blank');
            $('#modalOpcionesEvento').remove();
        });
    
        $('#cerrarModalEvento').on('click', function() {
            $('#modalOpcionesEvento').remove();
        });
    }
    
    function infocsv() {
        swal({
            title: "Formato del archivo CSV",
            text:
                "➤ IMPORTAR:\n" +
                "Las columnas 1 a 7 son obligatorias:\n" +
                "1. Empresa, 2. Correo, 3. Dirección, 4. Barrio, 5. Ciudad, 6. Contacto, 7. Teléfono\n" +
                "8 a 10. Sector/CIIU (opcional): deben ser códigos CIIU válidos si se proporcionan.\n\n" +
                "➤ ACTUALIZAR:\n" +
                "Solo se requiere la columna 1 (nombre exacto de la empresa).\n\n" +
                "⚠️ Nota: La primera línea del archivo siempre se descarta por ser el encabezado.",
            icon: "info",
            showCancelButton: true,
            confirmButtonColor: "#1E90FF", // azul
            cancelButtonColor: "#28a745",  // verde
            confirmButtonText: "Formato Importar",
            cancelButtonText: "Formato Actualizar",
            closeOnConfirm: false,
            closeOnCancel: false,
            showLoaderOnConfirm: false
        }, function(isConfirm) {
            if (isConfirm) {
                window.open('formato_importar.csv', '_blank');
            } else {
                window.open('formato_actualizar.csv', '_blank');
            }
            swal.close(); // cerrar manualmente
        });
    }
    
    $(document).ready(function() {
        // Evento para actualizar la tabla cuando cambia el filtro
        $('#edatos').change(function() {
            dataTableLista.ajax.reload();
        });
        $('#ellamadas').change(function() {
            dataTableLlamadas.ajax.reload();
        });
        $('#ecitas').change(function() {
            dataTableCitas.ajax.reload();
        });
        
        $(".chosen-select").chosen({disable_search_threshold: 10});
        
        $('.newform').submit(function(e) {
            e.preventDefault();
        
            // Desactivar el botón de submit
            let submitButton = $("button[type=submit]");
            $("button[type=submit]").prop("disabled", true);
            
            // Mostrar alerta de espera
            swal({
                title: "Espere un momento...",
                text: "Procesando su solicitud",
                icon: "info",
                buttons: false,
                closeOnClickOutside: false,
                closeOnEsc: false
            });
        
            var action = $(this).attr('action');
            var formData = new FormData(this);
        
            $.ajax({
                url: action,
                type: "post",
                dataType: 'json', // Se cambió a JSON para mejor manejo de respuesta
                data: formData,
                contentType: false,  // Deshabilitar el tipo de contenido predeterminado
                processData: false,  // Deshabilitar el procesamiento automático de los datos
                timeout: 10000, // 10 segundos de tiempo límite
        
                success: function(response) {
                    submitButton.prop("disabled", false); // Habilitar botón
        
                    if (response.success) {
                        swal("Completado", response.message || "El proceso ha finalizado correctamente.", "success");
                        if (response.hasOwnProperty('table') && Array.isArray(response.table)) { 
                            $(response.table).each(function(index, tableId) {
                                $(tableId).DataTable().ajax.reload(null, false);
                            });
                        }
                        if (response.hasOwnProperty('modal') && response.modal === true) { 
                            $(".modal").modal('hide'); 
                        }
                        // LIMPIAR FORMULARIO
                        $('.newform')[0].reset(); // Resetear el formulario completo
                        $(".newform select").val("").trigger("chosen:updated"); // Limpiar selects Chosen
                        $(".newform input[type=checkbox], .newform input[type=radio]").prop("checked", false); // Limpiar checkboxes y radios
              
                        
                    } else {
                        swal("Error", response.message || "Hubo un problema con la solicitud.", "error");
                    }
                },
        
                error: function(xhr, status, error) {
                    submitButton.prop("disabled", false); // Habilitar botón
        
                    let errorMessage = "Error desconocido, inténtelo de nuevo.";
                    if (status === "timeout") {
                        errorMessage = "El servidor tardó demasiado en responder.";
                    } else if (xhr.status === 500) {
                        errorMessage = "Error interno del servidor (500).";
                    } else if (xhr.status === 404) {
                        errorMessage = "La URL de destino no fue encontrada (404).";
                    } else if (xhr.responseText) {
                        errorMessage = xhr.responseText;
                    }
        
                    swal("Fallo en la conexión", errorMessage, "error");
                }
            });
        });
        
        $('select[name=accion]').on('change', function() {
            let valor = $(this).val();  
            // Ocultar todas las secciones antes de mostrar la correcta
            $('#select-acciones').html(''); 
            if (valor === '4') {
                $.post('acciones.php', { addcita: 'true' }, function(data) {
                    $('#select-acciones').html(data);
                });
            } else if (valor === '5') {
                $.post('acciones.php', { addcall: 'true' }, function(data) {
                    $('#select-acciones').html(data);
                });
            }
        });
        
        $('#tipo-seleccion').on('change', function () {
            const valor = $(this).val();
            if (valor === 'semana') {
                $('#grupo-semana').show();
                $('#grupo-mes').hide();
                $('#grupo-mes select').val([]);
            } else if (valor === 'mes') {
                $('#grupo-mes').show();
                $('#grupo-semana').hide();
                $('#grupo-semana input[type="checkbox"]').prop('checked', false);
            } else {
                $('#grupo-semana, #grupo-mes').hide();
                $('#grupo-semana input[type="checkbox"]').prop('checked', false);
                $('#grupo-mes select').val([]);
            }
        });
            
    });
  </script>
</body>
</html>   