<?php
$r= '../../';
require_once($r."inc/config.php");

$mysqli = connectDB($r);
session_start();
$spe=$_SESSION['perfil'];
$idusuario=$_SESSION['id'];
$extraCondition = '';

$asignar = viewroleaccess(612);
$desicion = viewroleaccess(631);
$reagendar = viewroleaccess(632);
$finalizar = viewroleaccess(633);
$brochure = viewroleaccess(634);
$linkevent = viewroleaccess(635);


function htmlclear($row) {
    global $asignar, $reagendar, $finalizar, $brochure, $linkevent;
    $icons = [];
    switch ($row['idestado']) {
        case 1: $icons[] = '<i style="cursor:pointer" title="Acciones '.$row['empresa'].'" onclick="asignar('.$row['id'].',\'cita\')" class="text-warning fa fa-user-plus fa-2x mr-2"></i>'; break;
        case 2: $icons[] = '<i style="cursor:pointer" title="Confirmar cita" onclick="decisionTarea('.$row['id'].',\'cita\')" class="text-warning fa  fa-exclamation-circle fa-2x mr-2"></i>'; break;
        case 3:
            $icons[] = '<i style="cursor:pointer" title="Modificar cita" onclick="reagendar('.$row['id'].',\'cita\')" class="text-primary fa fa-calendar-check-o fa-2x mr-2"></i>';
            $icons[] = '<i style="cursor:pointer" title="Finalizar cita" onclick="finalizada('.$row['id'].',\'cita\')" class="text-success fa fa-check fa-2x mr-2"></i>';
            $icons[] = '<i style="cursor:pointer" title="Finalizar cita" onclick="sendmail('.$row['id_data'].',\'cita\')" class="text-info fa fa-envelope fa-2x mr-2"></i>';
            $icons[] = '<i style="cursor:pointer" title="Compartir cita" onclick="linkevent('.$row['id'].',\'cita\')" class="fa fa-share-alt fa-2x mr-2"></i>';
            break;
        case 4:
            $icons[] = '<i style="cursor:pointer" title="Finalizar cita" onclick="sendmail('.$row['id_data'].',\'cita\')" class="text-info fa fa-envelope fa-2x mr-2"></i>';
            $icons[] = '<i style="cursor:pointer;color:olive" title="Fidelizar llamada" onclick="fidelizar('.$row['id_data'].',\'cita\')" class="text-primnary fa fa-user-plus fa-2x mr-2"></i>';
            break;
        case 5: case 7: case 8:
            $icons[] = '<i style="cursor:pointer" title="Modificar cita" onclick="reagendar('.$row['id'].',\'cita\')" class="text-primary fa fa-calendar-check-o fa-2x mr-2"></i>';
            $icons[] = '<i style="cursor:pointer" title="Finalizar cita" onclick="sendmail('.$row['id_data'].',\'cita\')" class="text-info fa fa-envelope fa-2x mr-2"></i>';
            $icons[] = '<i style="cursor:pointer" title="Compartir cita" onclick="linkevent('.$row['id'].',\'cita\')" class="fa fa-share-alt fa-2x mr-2"></i>';
            break;
        case 9: $icons[] = '<i style="cursor:pointer" title="Acciones '.$row['empresa'].'" onclick="asignar('.$row['id'].',\'cita\')" class="text-danger fa fa-user-plus fa-2x mr-2"></i>'; break;
    }
    return implode('', $icons);
}


/*
 * DataTables example server-side processing script.
 *
 * Please note that this script is intentionally extremely simple to show how
 * server-side processing can be implemented, and probably shouldn't be used as
 * the basis for a large complex system. It is suitable for simple use cases as
 * for learning.
 *
 * See https://datatables.net/usage/server-side for full details on the server-
 * side processing requirements of DataTables.
 *
 * @license MIT - https://datatables.net/license_mit
 */
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'call_data_visitas';
 
// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes

$columns = array(
    array( 'db' => 't1.id_usuario_asignado'),
    array( 'db' => 't1.id_usuario_cierre'),
    array( 'db' => 't1.id_data'),
    array( 'db' => 't1.estado AS idestado'),
    array( 'db' => 't1.id', 'dt' => 0 ),
    array( 'db' => 't2.empresa', 'dt' => 1 ),
    array( 'db' => 't1.tipo',   'dt' => 2 ),
    array( 'db' => 'CONCAT(t1.fecha, " - ", t1.hora)',   'dt' => 3 ),
    array( 'db' => 't1.servicio',   'dt' => 4 ),
    array( 'db' => 'COALESCE(t3.nombre, "")', 'dt' => 5 ), // Manejo de NULL
    array( 'db' => 't4.estado',  'dt' => 6 ),
    array(
        'db'        => 't1.id',
        'dt'        => 7,
        'formatter' => function( $d, $row ) {
            return htmlclear($row);
        })
    
);

// SQL server connection information
$sql_details = array(
    'user' => $bduser,
    'pass' => $bdpass,
    'db'   => $bdname,
    'host' => $server,
    'charset' => 'utf8' // Depending on your PHP and MySQL config, you may need this
);

 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
require( 'ssp.class.php' );
$joinQuery = "
    FROM `{$table}` AS `t1` INNER JOIN `call_data_clientes` AS `t2` ON (`t2`.`id` = `t1`.`id_data`)
    LEFT JOIN `z_usuarios` AS `t3` ON (`t3`.`id` = `t1`.`id_usuario_asignado`)
    LEFT JOIN `call_data_visitas_estados` AS `t4` ON (`t4`.`id` = `t1`.`estado`)
";

// Validar si existe 'tbestado' en GET y es diferente de "Todos"
if (isset($_GET['tbestado']) && $_GET['tbestado'] !== 'todos') {
    $tbestado = $_GET['tbestado'];
    $extraCondition = "t1.estado = '$tbestado'";
}


echo json_encode( SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraCondition), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

