<?php
$r= '../../';
require_once($r."inc/config.php");

$mysqli = connectDB($r);
session_start();
$spe=$_SESSION['perfil'];
$idusuario=$_SESSION['id'];
$extraCondition = '';

$acciones = viewroleaccess(611);
$asignar = viewroleaccess(611);
$cita = viewroleaccess(612);
$reagendar = viewroleaccess(613);

function htmlclear($row) {
    global $acciones, $cita, $reagendar, $asignar;

    $icons = [];

    // Ícono de acciones generales
    if(!$row['estado']){$icons[] = '<i style="cursor:pointer" title="Acciones '.$row['empresa'].'" onclick="acciones('.$row['id'].')" class="text-primary fa fa-gear fa-2x mr-2"></i>';}
    //$icons[] .= '<i style="cursor:pointer" title="Acciones '.$row['empresa'].'" onclick="sendmail('.$row['id'].')" class="text-info fa fa-envelope fa-2x mr-2"></i>';
    return implode('', $icons);
}

function htmlsectores($id_cliente) {
    global $mysqli; // Asegúrate que esta conexión está disponible

    $sql = "
        SELECT GROUP_CONCAT(s.sector SEPARATOR ', ') AS sectores
        FROM call_data_clientes_sectores cs
        INNER JOIN call_data_sectores_economico s ON s.id = cs.id_sector
        WHERE cs.id_data = ?
    ";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("i", $id_cliente);
    $stmt->execute();
    $stmt->bind_result($sectores);
    $stmt->fetch();
    $stmt->close();

    return $sectores ?: '';
}

/*
 * DataTables example server-side processing script.
 *
 * Please note that this script is intentionally extremely simple to show how
 * server-side processing can be implemented, and probably shouldn't be used as
 * the basis for a large complex system. It is suitable for simple use cases as
 * for learning.
 *
 * See https://datatables.net/usage/server-side for full details on the server-
 * side processing requirements of DataTables.
 *
 * @license MIT - https://datatables.net/license_mit
 */
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'call_data_clientes';
 
// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes

$columns = array(
    array( 'db' => 't1.id'),
    array( 'db' => 't1.empresa', 'dt' => 0 ),
    array( 'db' => 't1.correo', 'dt' => 1 ),
    array( 'db' => 't1.direccion', 'dt' => 2 ),
    array( 'db' => 't1.contacto', 'dt' => 3 ),
    array( 'db' => 't1.telefono', 'dt' => 4 ),
    array( 'db' => 't1.tipo',   'dt' => 5 ),
    array( 'db' => 't1.dias',   'dt' => 6 )
    
);

// SQL server connection information
$sql_details = array(
    'user' => $bduser,
    'pass' => $bdpass,
    'db'   => $bdname,
    'host' => $server,
    'charset' => 'utf8' // Depending on your PHP and MySQL config, you may need this
);

 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
require( 'ssp.class.php' );
$joinQuery = "
    FROM `{$table}` AS `t1`
    INNER JOIN `z_usuarios` AS `t4` ON (`t4`.`id` = `t1`.`id_asesor`)
    INNER JOIN `call_data_estados` AS `t3` ON (`t3`.`id` = `t1`.`estado`)
";

// Validar si existe 'tbestado' en GET y es diferente de "Todos"
$extraCondition = " `tipo` IS NOT NULL AND `dias` IS NOT NULL";

echo json_encode( SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraCondition), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

