<?php
$r= '../';
$titlepage='Lista de Citas Programdas';
require_once($r."inc/config.php");
validSession($r);
$mysqli = connectDB($r);
$spe = $_SESSION['perfil'];
$idusuario = $_SESSION['userid'];
roleaccess(410);
include $r."inc/head.php"; ?>

<body class="fixed-nav sticky-footer sidenav-toggled bg-dark" id="page-top">
    <?php include $r."inc/nav.php"; ?>
 
    <div class="content-wrapper">
        <div class="container-fluid">
          <!-- Example DataTables Card-->
          <div class="card mb-3">
            <div class="h3 card-header">
              <i class="fa fa-table"></i> <?= $titlepage; ?>
              <select id="tbestados" class="form-control col-sm-3 float-right">
                  <option selected>Pendiente</option>
                  <option>Confirmada</option>
                  <option>Completada</option>
                  <option>Cancelada</option>
                  <option>Reprogramada</option>
                  <option>No Asistió</option>
                  <option value="todos" >Todos</option>
              </select>
              
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-bordered table-striped" id="dataTable" width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th>ID</th>
                      <th>Empresa</th>
                      <th>Tipo</th>
                      <th>Fecha</th>
                      <th>Hora</th>
                      <th>Usuario</th>
                      <th>Estado</th>
                      <th style="max-width: 120px;"><i class="fa fa-gear"></i></th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th>ID</th>
                      <th>Empresa</th>
                      <th>Tipo</th>
                      <th>Fecha</th>
                      <th>Hora</th>
                      <th>Usuario</th>
                      <th>Estado</th>
                      <th style="max-width: 120px;"><i class="fa fa-gear"></i></th>
                    </tr>
                  </tfoot>
                  <tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
    </div>
    
    <style>
    .chosen-container {
        width: 100%!important;
    }
    .sweet-overlay{
        z-index:1999;
    }
    #ModalAddProductoEntrada{
        z-index:1060!important;
        background: rgba(0, 0, 0, 0.4);
    }
    #seriales{
        display:block;
        padding: 4px;
    }
    .serial{
            border: 1px solid #000;
        border-radius: 20px;
        display: inline-block;
        padding: 0px;
        background: #d7d7d7;
    }
    .serial input{
        border: none;
        background: none;
        text-align: center;
    }
    .serial i{
        color:red;
        margin-right:3px;
    }
    @media (min-width: 1140px) {
        .modal-lg {
            max-width: 1000px; /* Ancho del modal para pantallas grandes */
        }
    }
    </style>
   <!-- Modal Acciones -->
    <div class="modal fade" id="acciones" tabindex="-1" aria-labelledby="accionesLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="accionesLabel">Acciones de LLamada</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    
                    <!-- Formulario -->
                        <h6>Informacion del Cliente</h6>
                        <div class="container">
                        <form class="newform" id="data-cliente" method="POST" action="acciones.php">
                            <input type="hidden" name="iddatacliente" value="">
                    
                            <div class="row">
                                <!-- Primera Columna -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="empresa">Empresa</label>
                                        <input type="text" class="form-control" id="empresa" name="empresa" required>
                                    </div>
                    
                                    <div class="form-group">
                                        <label for="contacto">Contacto</label>
                                        <input type="text" class="form-control" id="contacto" name="contacto">
                                    </div>
                                </div>
                    
                                <!-- Segunda Columna -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="correo">Correo</label>
                                        <input type="email" class="form-control" id="correo" name="correo" required>
                                    </div>
                    
                                    <div class="form-group">
                                        <label for="telefono">Teléfono</label>
                                        <input type="tel" class="form-control" id="telefono" name="telefono" required>
                                    </div>
                                </div>
                    
                                <!-- Tercera Columna -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Sector Económico</label>
                                        <select name="sector" class="chosen-select form-control">
                                            <option value="" selected disabled>Seleccione el sector económico...</option>
                                            <?php $qry1 = $mysqli->query("SELECT * FROM call_data_sectores_economico ORDER BY sector ASC"); 
                                            while($row1 = $qry1->fetch_assoc()){ ?>
                                                <option class="text-uppercase" value="<?= $row1['id']; ?>"><?= $row1['sector']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                    
                                    <div class="form-group">
                                        <label for="direccion">Dirección</label>
                                        <input type="text" class="form-control" id="direccion" name="direccion">
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                        
                    </hr>
                    <!-- Botones en la cabecera -->
                    <div>
                        <label>Eviar brochure</label>
                        <select form="data-cliente" name="brochure" class="form-control" required>
                            <option value="0" selected>No</option>
                            <option value="1">si</option>
                        </select>
                    </div>
                    <!-- Botones en la cabecera -->
                    <div>
                        <label>accion LLamada</label>
                        <select form="data-cliente" name="accion" class="form-control" required>
                            <option value="" selected disabled>Seleccione una accion...</option>
                            <?php $qry1 = $mysqli->query("SELECT * FROM call_data_estados WHERE id!=0 ORDER BY id ASC"); 
                            while($row1 = $qry1->fetch_assoc()){ ?>
                                <option value="<?= $row1['id']; ?>" title="<?= $row1['descripcion']; ?>"><?= $row1['label']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div id="select-acciones">
                    </div>
                    <!-- Botones en la cabecera -->
                    <div class="mt-4 mb-2">
                        <button type="button" class="btn btn-danger m-1 float-right" data-dismiss="modal" aria-label="Cerrar">Cerrar</button>
                        <button class="btn btn-primary m-1 float-right" type="submit" form="data-cliente">Finalizar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
    <!-- Modal Cita -->
    <div class="modal fade" id="cita" tabindex="-1" aria-labelledby="citaLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="citaLabel">Cita</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Contenido del modal de Cita.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Modal Llamada -->
    <div class="modal fade" id="llamada" tabindex="-1" aria-labelledby="llamadaLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="llamadaLabel">Llamada</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Contenido del modal de Llamada.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>
  <?php include $r."inc/foot.php"; ?>
  
  <script>
    // Inicialización de DataTable
    var dataTable = $('#dataTable').DataTable({
        "order": [[0, 'desc']],
        "ordering": true,
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": 'server_side/data_citas.php',
            "data": function(d) {
                d.tbestado = $('#tbestados').val(); // Agrega el parámetro al request
            }
        },
        "dom": 'lfBtipr', // Agrega B para los botones
        "buttons": [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
  
    function acciones(id){
        $.post( "acciones.php", { infodatacliente: id })
          .done(function( response ) {
            if (response.success) {
                let data = JSON.parse(response.message);
                $('input[name=iddatacliente]').val(data.id);
                $('input[name=empresa]').val(data.empresa);
                $('input[name=correo]').val(data.correo);
                $('select[name=sector]').val(data.sector_economico).trigger("chosen:updated");
                $('input[name=direccion]').val(data.direccion);
                $('input[name=contacto]').val(data.contacto);
                $('input[name=telefono]').val(data.telefono);
                $('#acciones').modal('show');
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                swal(response.message);
            }
        });
    }
    
    function cita(id){
        $('#cita').modal('show');   
    }
    
    function llamada(id){
        $('#llamada').modal('show');   
    }
    
    
    $(document).ready(function() {
    
        // Evento para actualizar la tabla cuando cambia el filtro
        $('#tbestados').change(function() {
            dataTable.ajax.reload(); // Recarga la tabla con el nuevo valor de tbestado
        });
        
        
        $('.newform').submit(function(e) {
            e.preventDefault();
        
            // Desactivar el botón de submit
            let submitButton = $("button[type=submit]");
            $("button[type=submit]").prop("disabled", true);
            
            let isValid = true; // Variable para controlar la validación

            // Validar todos los select de Chosen con atributo required
            $('.chosen-select[required]').each(function() {
                if ($(this).val() === null || $(this).val().length === 0) {
                    isValid = false;
                    $(this).next('.chosen-container').addClass('border-danger'); // Agregar borde rojo en chosen
                } else {
                    $(this).next('.chosen-container').removeClass('border-danger'); // Quitar borde rojo si es válido
                }
            });
        
            if (!isValid) {
                swal("Error", "Debe seleccionar un valor en todos los campos obligatorios.", "error");
                return false; // Detener el envío del formulario
            }
        
            // Mostrar alerta de espera
            swal({
                title: "Espere un momento...",
                text: "Procesando su solicitud",
                icon: "info",
                buttons: false,
                closeOnClickOutside: false,
                closeOnEsc: false
            });
        
            var action = $(this).attr('action');
            var formData = new FormData(this);
        
            $.ajax({
                url: action,
                type: "post",
                dataType: 'json', // Se cambió a JSON para mejor manejo de respuesta
                data: formData,
                contentType: false,  // Deshabilitar el tipo de contenido predeterminado
                processData: false,  // Deshabilitar el procesamiento automático de los datos
                timeout: 10000, // 10 segundos de tiempo límite
        
                success: function(response) {
                    submitButton.prop("disabled", false); // Habilitar botón
        
                    if (response.success) {
                        swal("Completado", response.message || "El proceso ha finalizado correctamente.", "success");
                    } else {
                        swal("Error", response.message || "Hubo un problema con la solicitud.", "error");
                    }
                },
        
                error: function(xhr, status, error) {
                    submitButton.prop("disabled", false); // Habilitar botón
        
                    let errorMessage = "Error desconocido, inténtelo de nuevo.";
                    if (status === "timeout") {
                        errorMessage = "El servidor tardó demasiado en responder.";
                    } else if (xhr.status === 500) {
                        errorMessage = "Error interno del servidor (500).";
                    } else if (xhr.status === 404) {
                        errorMessage = "La URL de destino no fue encontrada (404).";
                    } else if (xhr.responseText) {
                        errorMessage = xhr.responseText;
                    }
        
                    swal("Fallo en la conexión", errorMessage, "error");
                }
            });
        });
        
        $('select[name=accion]').on('change', function() {
            let valor = $(this).val();  
            // Ocultar todas las secciones antes de mostrar la correcta
            $('#select-acciones').html(''); 
            if (valor === '4') {
                $.post('acciones.php', { addcita: 'true' }, function(data) {
                    $('#select-acciones').html(data);
                });
            } else if (valor === '5') {
                $.post('acciones.php', { addcall: 'true' }, function(data) {
                    $('#select-acciones').html(data);
                });
            }
        });

    });
  </script>
</body>
</html>   