<?php

$logo = base64_encode(file_get_contents('https://guiatransportes.com/app/imgs/site/logo_guia.png'));
$facebook = base64_encode(file_get_contents('https://guiatransportes.com/app/imgs/facebook.png'));
$linkedin = base64_encode(file_get_contents('https://guiatransportes.com/app/imgs/linkedin.png'));
$instagram = base64_encode(file_get_contents('https://guiatransportes.com/app/imgs/instagram.png'));
$estimado = $_GET['estimado'] ?? 'cliente';

$contenido = <<<HTML
<!DOCTYPE html>
<html lang="es">
<head><meta charset="UTF-8"></head>
<body style="margin:0; padding:0; background:#f4f4f4; font-family:Arial,sans-serif;">
  <div style="max-width:600px; margin:auto; background:#fff; border-radius:6px; overflow:hidden; box-shadow:0 0 10px rgba(0,0,0,0.1);">
    <div style="background:#eee; text-align:center; padding:20px;">
      <img src="data:image/png;base64,{$logo}" alt="Logo Guiatransportes" style="max-width:180px; height:auto;">
    </div>
    <div style="padding:30px 20px; color:#333; font-size:16px; line-height:1.6;">
      <p>Estimados {$estimado},</p>
      <p>Desde <strong>Guiatransportes</strong> nos dirigimos a ustedes con el fin de poner a su disposición nuestro portafolio de soluciones tecnológicas orientadas al sector transporte, logística y distribución.</p>
      <p>Contamos con experiencia en el desarrollo de plataformas de gestión operativa, automatización de comunicaciones con clientes, integración de sistemas logísticos, desarrollo web a medida y herramientas especializadas para la trazabilidad de servicios.</p>
      <p>Adjuntamos un brochure donde encontrarán información más detallada sobre cada uno de nuestros servicios y cómo pueden adaptarse a sus necesidades específicas.</p>
      <p>Será un gusto para nuestro equipo poder acompañarlos en la optimización y crecimiento de sus procesos tecnológicos. Quedamos atentos para agendar una reunión en caso de que deseen ampliar la información.</p>
      <p>Atentamente,<br><strong>Equipo de Guiatransportes</strong></p>
    </div>
    <div style="background:#eee; text-align:center; padding:20px;">
      <div style="margin-bottom:10px;">
        <a href="#"><img src="data:image/png;base64,{$facebook}" style="width:24px; height:24px; margin:0 8px;" alt="Facebook"></a>
        <a href="#"><img src="data:image/png;base64,{$linkedin}" style="width:24px; height:24px; margin:0 8px;" alt="LinkedIn"></a>
        <a href="#"><img src="data:image/png;base64,{$instagram}" style="width:24px; height:24px; margin:0 8px;" alt="Instagram"></a>
      </div>
      <div style="font-size:14px; color:#4483a0;">
        Guiatransportes<br>www.guiatransportes.com • info@guiatransportes.com • +57 123 456 7890
      </div>
    </div>
  </div>
</body>
</html>
HTML;

// Enviar email
$to = "destinatario@ejemplo.com";
$subject = "Presentación de Servicios - Guiatransportes";
$headers = "MIME-Version: 1.0\r\n";
$headers .= "Content-type:text/html;charset=UTF-8\r\n";
$headers .= "From: info@guiatransportes.com\r\n";

if (mail($to, $subject, $contenido, $headers)) {
    echo "Correo enviado con éxito";
} else {
    echo "Error al enviar el correo";
}
