<?php
// Mostrar errores de PHP para depuración
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../vendor/autoload.php';

use Google\Client;
use Google\Service\Calendar;
use Google\Service\Calendar\Event;
use Google\Service\Calendar\EventDateTime;
use Google\Service\Calendar\ConferenceData;
use Google\Service\Calendar\CreateConferenceRequest;
use Google\Service\Calendar\ConferenceSolutionKey;

try {
    echo "➡️ Iniciando script...<br>";

    // Ruta del archivo de credenciales
    $credenciales_path = '/home/grupoael/guiatransportes.com/app/call-center/guiatrasnportes-58faa993002d.json';
    
    echo "🔍 Verificando existencia del archivo de credenciales...<br>";
    if (!file_exists($credenciales_path)) {
        throw new Exception("❌ El archivo de credenciales no existe en: $credenciales_path");
    }
    echo "✅ Archivo de credenciales encontrado.<br>";

    // Configurar cliente de Google
    echo "🔍 Configurando cliente de Google...<br>";
    $client = new Client();
    $client->setAuthConfig($credenciales_path);
    $client->addScope(Calendar::CALENDAR);
    echo "✅ Cliente de Google configurado correctamente.<br>";

    // Crear servicio de Calendar
    echo "🔍 Creando servicio de Google Calendar...<br>";
    $service = new Calendar($client);
    echo "✅ Servicio de Google Calendar creado.<br>";

    // Definir evento
    echo "🔍 Definiendo evento...<br>";
    $event = new Event([
        'summary' => 'Reunión de prueba',
        'start' => new EventDateTime(['dateTime' => date('c', strtotime('+1 hour'))]),
        'end' => new EventDateTime(['dateTime' => date('c', strtotime('+2 hours'))]),
    ]);
    echo "✅ Evento definido correctamente.<br>";

    // Configurar Google Meet (Forzado)
    echo "🔍 Configurando Google Meet...<br>";
    $conferenceRequest = new CreateConferenceRequest();
    $conferenceRequest->setRequestId(uniqid());
    $conferenceSolutionKey = new ConferenceSolutionKey();
    $conferenceSolutionKey->setType("hangoutsMeet");
    $conferenceRequest->setConferenceSolutionKey($conferenceSolutionKey);
    $conferenceData = new ConferenceData();
    $conferenceData->setCreateRequest($conferenceRequest);
    $event->setConferenceData($conferenceData);
    echo "✅ Configuración de Google Meet lista.<br>";

    // Insertar evento en el calendario
    echo "🔍 Insertando evento en Google Calendar...<br>";
    $calendarId = 'primary';
    $event = $service->events->insert($calendarId, $event, ['conferenceDataVersion' => 1]);
    echo "✅ Evento insertado correctamente.<br>";

    // Mostrar enlace de Google Meet
    if ($event->getHangoutLink()) {
        echo "✅ Enlace de Google Meet generado: <a href='" . $event->getHangoutLink() . "' target='_blank'>" . $event->getHangoutLink() . "</a>";
    } else {
        throw new Exception("⚠️ No se generó el enlace de Google Meet.");
    }

} catch (Exception $e) {
    // Capturar y mostrar cualquier error
    echo "❌ Error detectado: " . $e->getMessage();
}
?>
