<?php
$r= '../';
require_once($r."inc/config.php");
$mysqli = connectDB($r);
session_start();
$iduser=$_SESSION['userid'];

if(isset($_POST['nueva_auditoria'])){
    // Obtener y sanitizar datos del formulario
    $auditor = $mysqli->real_escape_string(trim($_POST['auditor']));
    $cargo_auditor = $mysqli->real_escape_string(trim($_POST['cargo_auditor']));
    $observador = $mysqli->real_escape_string(trim($_POST['observador']));
    $cargo_observador = $mysqli->real_escape_string(trim($_POST['cargo_observador']));
    $ciudad = $mysqli->real_escape_string(trim($_POST['ciudad']));
    $empresa = $mysqli->real_escape_string(trim($_POST['empresa']));
    $zona = $mysqli->real_escape_string(trim($_POST['zona']));
    $fecha_inicio = $mysqli->real_escape_string(trim($_POST['fecha_inicio']));
    $hora_inicio = $mysqli->real_escape_string(trim($_POST['hora_inicio']));
    
    // Validar que los campos no estén vacíos
    if (empty($auditor) || empty($cargo_auditor) || empty($observador) || empty($cargo_observador) || empty($ciudad) || empty($empresa) || empty($zona) || empty($fecha_inicio) || empty($hora_inicio)) {
        echo json_encode(['success' => false, 'message' => 'Todos los campos son obligatorios.']);
        exit;
    }
    
    // Validar que la fecha de inicio no sea anterior a hoy
    if (strtotime($fecha_inicio) < strtotime(date('Y-m-d'))) {
        echo json_encode(['success' => false, 'message' => 'La fecha de inicio no puede ser anterior a hoy.']);
        exit;
    }
    
    // Aquí se puede realizar la actualización o inserción en la base de datos
    // Ejemplo de actualización (adaptar según necesidad)
    $query = "INSERT INTO `z_auditorias`(`id_usuario`, `id_empresa`, `id_zona`, `id_municipio`, `fecha_inicio` , `hora_inicio`) VALUES ('$iduser', '$empresa', '$zona', '$ciudad', '$fecha_inicio', '$hora_inicio')";
    if ($mysqli->query($query)) {
        $id_auditoria = $mysqli->insert_id; // Obtener el ID insertado
    
        // Insertar en la tabla `z_auditorias_auditores`
        $query_auditor = "INSERT INTO `z_auditorias_auditores`(`id_auditoria`, `nombre`, `cargo`) VALUES ('$id_auditoria', '$auditor', '$cargo_auditor')";
        if ($mysqli->query($query_auditor)) {
            // Insertar en la tabla `z_auditorias_auditores`
            $query_auditor = "INSERT INTO `z_auditorias_auditores`(`id_auditoria`, `nombre`, `cargo`) VALUES ('$id_auditoria', '$observador', '$cargo_observador')";
            if ($mysqli->query($query_auditor)) {
                echo json_encode(['success' => true , 'message' => 'Tu petición ha sido procesada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al agregar el observador.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Error al agregar el auditor.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al crear la auditoria']);
    }
    exit();
}


if(isset($_POST['novedad'])){
    // Obtener y sanitizar datos del formulario
    $idauditoria = $mysqli->real_escape_string(trim($_POST['idauditoria']));
    $idproducto = $mysqli->real_escape_string(trim($_POST['idproducto']));
    $novedad = $mysqli->real_escape_string(trim($_POST['novedad']));
    
    // Validar que los campos no estén vacíos
    if (empty($novedad)) {
        echo json_encode(['success' => false, 'message' => 'Es necesaria describir la novedad encontrada.']);
        exit;
    }
    

    // Verificar si el registro ya existe
    $check_query = "SELECT * FROM `z_auditorias_novedades` WHERE `id_usuario` = '$iduser' AND `id_auditoria` = '$idauditoria' AND `id_producto` = '$idproducto'";
    $result = $mysqli->query($check_query);
    
    if ($result->num_rows > 0) {
        // El registro existe, actualizar el campo de novedad
        $update_query = "UPDATE `z_auditorias_novedades` SET `novedad` = '$novedad' WHERE `id_usuario` = '$iduser' AND `id_auditoria` = '$idauditoria' AND `id_producto` = '$idproducto'";
        if ($mysqli->query($update_query)) {
            echo json_encode(['success' => true, 'message' => 'Novedad actualizada.', 'closemodal' => 'loadnovedad']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Error al actualizar la novedad']);
        }
    } else {
        // El registro no existe, insertar un nuevo registro
        $insert_query = "INSERT INTO `z_auditorias_novedades` (`id_usuario`, `id_auditoria`, `id_producto`, `novedad`) VALUES ('$iduser', '$idauditoria', '$idproducto', '$novedad')";
        if ($mysqli->query($insert_query)) {
            echo json_encode(['success' => true, 'message' => 'Novedad agregada.', 'closemodal' => 'loadnovedad']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Error al crear la novedad']);
        }
    }
    exit();
}
if(isset($_POST['finalizar_auditoria'])){
    $idauditoria = $_POST['finalizar_auditoria'];
    // Obtener y sanitizar datos del formulario
    $fecha_proxima = isset($_POST['fecha_proxima']) ? trim($_POST['fecha_proxima']) : '';
    $situacion = isset($_POST['situacion']) ? trim($_POST['situacion']) : '';
    $recomendaciones = isset($_POST['recomendaciones']) ? trim($_POST['recomendaciones']) : '';
    $compromiso = isset($_POST['compromiso']) ? trim($_POST['compromiso']) : '';
    $responsable = isset($_POST['responsable']) ? trim($_POST['responsable']) : '';
    $fecha_cumplimiento = isset($_POST['fecha_cumplimiento']) ? trim($_POST['fecha_cumplimiento']) : '';
    $seguimiento = isset($_POST['seguimiento']) ? trim($_POST['seguimiento']) : '';
    
    // Validaciones
    $valid = true;
    $messages = [];
    
    // Verificar que no estén vacíos
    if (empty($fecha_proxima) || empty($situacion) || empty($recomendaciones) || empty($compromiso) || empty($responsable) || empty($fecha_cumplimiento) || empty($seguimiento)) {
        $valid = false;
        $messages = 'Todos los campos deben estar completos.';
    }
    
    // Validar fecha de próxima debe ser posterior a la fecha actual
    $fecha_actual = date('Y-m-d');
    if ($fecha_proxima <= $fecha_actual) {
        $valid = false;
        $messages = 'La fecha de próxima debe ser posterior a la fecha actual.';
    }
    
    // Validar fecha de cumplimiento debe ser antes de la fecha de próxima
    if ($fecha_cumplimiento >= $fecha_proxima) {
        $valid = false;
        $messages = 'La fecha de cumplimiento debe ser antes de la fecha de próxima.';
    }
    
    // Validar datos que puedan dañar la base de datos
    $fecha_proxima = $mysqli->real_escape_string($fecha_proxima);
    $situacion = $mysqli->real_escape_string($situacion);
    $recomendaciones = $mysqli->real_escape_string($recomendaciones);
    $compromiso = $mysqli->real_escape_string($compromiso);
    $responsable = $mysqli->real_escape_string($responsable);
    $fecha_cumplimiento = $mysqli->real_escape_string($fecha_cumplimiento);
    $seguimiento = $mysqli->real_escape_string($seguimiento);
    
    // Resultados de la validación
    if ($valid) {
        // El registro existe, actualizar el campo de novedad
        $update_query = "UPDATE `z_auditorias` SET `fecha_proximo` = '$fecha_proxima', `situacion_evidenciada` = '$situacion', `recomendaciones` = '$recomendaciones', `compromiso` = '$compromiso', `responsable` = '$responsable', `fecha_cumplimiento` = '$fecha_cumplimiento', `seguimiento` = '$seguimiento', `estado` = '2' WHERE `id` = '$idauditoria'";
        if ($mysqli->query($update_query)) {
            echo json_encode(['success' => true, 'message' => 'Novedad actualizada.', 'closemodal' => 'loadnovedad']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Error al actualizar la novedad']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => $messages]);
    }
    
    $mysqli->close();
}



if(isset($_POST['infonovedad'])){
    // Obtener y sanitizar datos del formulario
    $idauditoria = $mysqli->real_escape_string(trim($_POST['idauditoria']));
    $idproducto = $mysqli->real_escape_string(trim($_POST['infonovedad']));
    
    $sqlnovedad = $mysqli->query("SELECT novedad FROM `z_auditorias_novedades` WHERE `id_auditoria` = $idauditoria AND `id_producto` = $idproducto");
    $rownovedad = $sqlnovedad->fetch_assoc();
    echo $rownovedad['novedad']; 
    exit();
}
