<?php
$r= '../';
$titlepage='AUDITORIAS';
require_once($r."inc/config.php");
validSession($r);
$mysqli = connectDB($r);
$spe = $_SESSION['perfil'];
$idusuario = $_SESSION['userid'];
roleaccess(501);
include $r."inc/head.php"; ?>

<body class="fixed-nav sticky-footer sidenav-toggled bg-dark" id="page-top">
    <?php include $r."inc/nav.php"; ?>
 
    <div class="content-wrapper">
        <div class="container-fluid">
          <!-- Example DataTables Card-->
          <div class="card mb-3">
              <div class=" card-header">
                <i class="fa fa-table"></i> <?= $titlepage; ?>
                <button class="btn btn-success float-right" data-toggle="modal" data-target="#modalnewauditoria"><i class="fa fa-plus"></i> Nueva Auditoria</button>
              
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-bordered table-striped" id="dataTable" width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th>ID</th>
                      <th>Usuario</th>
                      <th>Lugar</th>
                      <th>Auditor</th>
                      <th>Fecha</th>
                      <th><i class="fa fa-cog"></i></th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th>ID</th>
                      <th>Usuario</th>
                      <th>Lugar</th>
                      <th>Auditor</th>
                      <th>Fecha</th>
                      <th><i class="fa fa-cog"></i></th>
                    </tr>
                  </tfoot>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
    </div>
    
    <!-- Modal -->
    <div class="modal fade" id="modalnewauditoria" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">NUEVA AUDITORIA</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
         
            <div class="modal-body">
                    <input form="miFormulario" type="hidden" name="nueva_auditoria" value="true" required>
                    <div class="form-group">
                        <label>Auditor</label>
                        <input form="miFormulario" type="text" name="auditor" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Cargo</label>
                        <input form="miFormulario" type="text" name="cargo_auditor" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Observador presente</label>
                        <input form="miFormulario" type="text" name="observador" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Cargo</label>
                        <input form="miFormulario" type="text" name="cargo_observador" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="selectExample">Ciudad</label>
                        <select form="miFormulario"  id="ciudad" name="ciudad" class="chosen-select form-control" placeholder="Selecciones Ciudad">
                            <option selected disabled>Seleccione Ciudad...</option>
                            <? $sqlmunicipios = $mysqli->query("SELECT z_municipios.id, z_municipios.municipio, z_departamentos.departamento FROM `z_municipios` INNER JOIN z_departamentos ON z_municipios.departamento = z_departamentos.id");
                            while($rowmunicipio = $sqlmunicipios->fetch_assoc()){ ?>
                          <option value="<?= $rowmunicipio['id']; ?>"><?= $rowmunicipio['municipio'].' - '.$rowmunicipio['departamento']; ?></option>
                          <? } ?>
                            
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="selectExample">Empresa</label>
                        <select form="miFormulario" id="empresa" name="empresa" class="chosen-select form-control" placeholder="Selecciones empresa">
                            <option selected disabled>Seleccione empresa...</option>
                            <? $sqlmunicipios = $mysqli->query("SELECT * FROM z_usuarios_empresas WHERE id!=1");
                            while($rowmunicipio = $sqlmunicipios->fetch_assoc()){ ?>
                          <option value="<?= $rowmunicipio['id']; ?>"><?= $rowmunicipio['empresa']; ?></option>
                          <? } ?>
                            
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="selectExample">Zona Auditada</label>
                        <select form="miFormulario" id="zona" name="zona" class="chosen-select form-control" placeholder="Selecciones zona">
                            <option selected disabled>Seleccione zona...</option>
                            <? $sqlmunicipios = $mysqli->query("SELECT * FROM z_inventario_zonas");
                            while($rowmunicipio = $sqlmunicipios->fetch_assoc()){ ?>
                          <option value="<?= $rowmunicipio['id']; ?>"><?= $rowmunicipio['zona']; ?></option>
                          <? } ?>
                            
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Fecha de incio</label>
                        <input form="miFormulario" type="date" name="fecha_inicio" value="<?= date("Y-m-d"); ?>" class="form-control" id="dateExample">
                    </div>
                    <div class="form-group">
                        <label for="timeExample">Hora de inicio</label>
                        <input form="miFormulario" type="time" name="hora_inicio" value="<?= date("H:i:s"); ?>" class="form-control" id="timeExample">
                    </div>
                
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
                <form id="miFormulario" action="acciones.php" method="POST">
                <button type="submit" class="btn btn-success">EMPEZAR AUDITORIA</button>
                </form>
            </div>
        </div>
      </div>
    </div> 
    

  <?php include $r."inc/foot.php"; ?>
  <script>
     var table =  $('#dataTable').DataTable({
      "processing": true,
      "serverSide": true,
      "ajax": 'server_side/auditorias.php',
      "paging": true,
      "order": [[1, 'asc']],
       "lengthMenu": [[ -1], ["Todos"]],
      "ordering": true,
      "searching": true,
      "dom": 'lfBtipr', // Agrega B para los botones
      "buttons": [
            'copy', 'csv', 'excel', 'pdf', 'print'
            // Puedes agregar más botones según tus necesidades
        ],
      // Otras configuraciones...
    });
    </script>
    <script>
        $(document).ready(function() {
            $('#ciudad_chosen, #empresa_chosen, #zona_chosen').attr('style','width: 100%');

            // Manejo del envío del formulario con AJAX
            $('#miFormulario').on('submit', function(e) {
                e.preventDefault();
                
                 var action = $(this).attr('action');
                 var method = $(this).attr('method');
                 
                // Deshabilitar el botón de submit
                $('button[type="submit"]').prop('disabled', true);
                
                // Mostrar SweetAlert de procesamiento
                swal({
                    title: 'Procesando tu petición',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                // Simular una solicitud AJAX
                $.ajax({
                    url: action, // Cambia esto a la URL de tu script de procesamiento
                    method: method,
                    data: $(this).serialize(),
                    success: function(response) {
                        // Manejar la respuesta exitosa
                        var res = JSON.parse(response);
                        if (res.success) {
                            swal({
                                icon: 'success',
                                title: '¡Éxito!',
                                text: res.message
                            });
                            $('#dataTable').DataTable().ajax.reload();
                            $('#modalnewauditoria').modal('hide');
                        } else {
                            swal({
                                icon: 'error',
                                title: 'Error',
                                text: res.message
                            });
                        }
                        $('button[type="submit"]').prop('disabled', false);
                    },
                    error: function() {
                        // Manejar los errores
                        swal({
                            icon: 'error',
                            title: 'Error',
                            text: 'Hubo un problema al procesar tu petición.'
                        });
                        $('button[type="submit"]').prop('disabled', false);
                    }
                });
            });
        });
    </script>
</body>
</html>   