<?php
$r = "../";
require_once($r."inc/config.php");
$mysqli = connectDB($r);
$titlepage = 'Formato registro inventario';
$iduditoria = $_GET['id'];
$infoauditoria = sinfo($iduditoria,'z_auditorias');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <title><?= $titlepage; ?></title>
    <style>
        @page {
            size: 8.5in 11in; /* Tamaño carta: 8.5 x 11 pulgadas */
            margin: 1in; /* Márgenes de 1 pulgada */
        }
        body {
            margin: 0 auto;
            padding: 0;
            box-sizing: border-box;
            width: 8.5in; /* Ancho de la página */
            height: 11in; /* Altura de la página */
            font-family: "Arial", sans-serif;
            font-size:11px;
            background:#888888;
            -webkit-user-select: none; /* Chrome, Safari, Opera */
            -moz-user-select: none; /* Firefox */
            -ms-user-select: none; /* Internet Explorer/Edge */
            user-select: none; /* Non-prefixed version, currently supported by Chrome, Opera, and Edge */
        }
        .page {
            min-height:9in;
            page-break-after: always; /* Rompe la página después de cada sección */
            padding:25.5mm;
            background:#fff;
            margin-bottom:10px;
        }
        .page:last-child {
            page-break-after: auto; /* No añade salto de página después de la última página */
        }
        table {
            border-collapse: collapse; /* Colapsa los bordes para que no haya espacios entre ellos */
            width: 100%; /* Ajusta el ancho de la tabla al contenedor */
        }
        tr{
            width:100%;
        }
        tr.b, td.b {
            border: 1px solid black; /* Borde de 1px sólido y negro para celdas */
            padding: 2px; /* Espaciado interno de las celdas */
            margin:0;
            text-align: left; /* Alinea el texto a la izquierda */
        }
        .t-c{
            text-align:center!important;
        }
        .t-l{
            text-align:left!important;
        }
        .t-r{
            text-align:right!important;
        }
        .t-j{
            text-align:justify!important;
        }
        .t-n{
            font-weight:bold!important;
        }
        .header{
            display: flex;
            align-content: center;
            justify-content: center;
            align-items: center;
            padding:0px 0px 30px 0px;
        }
        .header div{
            width:33%;
            text-align:center;
        }
        
        .h {
            width: 100%; /* Ajusta al ancho del contenedor */
            box-sizing: border-box; /* Incluye padding en el cálculo del tamaño */
            height: var(--dynamic-height, auto); /* Usa la variable para altura */
        }

        /* Define las alturas en variables CSS */
        
        .h-100 {
            --dynamic-height: 100px;
        }
        .h-200 {
            --dynamic-height: 200px;
        }
        .h-300 {
            --dynamic-height: 300px;
        }
        .h-400 {
            --dynamic-height: 400px;
        }
        .fixed-buttons {
            position: fixed;
            bottom: 20px;
            right: 20px;
            display: flex;
            gap: 10px;
        }
        .fixed-buttons button {
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .fixed-buttons button:hover {
            background-color: #0056b3;
        }
        
        /* Opcional: deshabilitar selección de texto */
        .no-select {
            -webkit-user-select: none; /* Chrome, Safari */
            -moz-user-select: none; /* Firefox */
            -ms-user-select: none; /* Internet Explorer/Edge */
            user-select: none; /* Non-prefixed version, currently supported by Chrome, Opera, and Edge */
        }
        @media print {
            .page {
                padding: 0; /* Elimina el padding durante la impresión */
                margin: 0; /* Asegura que no haya márgenes adicionales */
            }
            .fixed-buttons {
                display:none;
            }
        }
    </style>
</head>
<body>
    <div class="page">
        <div class="header">
            <div><img src="<?= $r.$logosite; ?>" width="120px"></div>
            <div><p>Formato registro inventario</p></div>
            <div class="t-l"><p>Código: FR-OPE-<?= $iduditoria; ?><br>Versión:001<br>Fecha:<?= date('d/m/Y', strtotime($infoauditoria['fecha'])); ?></p></div>
        </div>
        <table>
          <tr>
            <td class="b t-c t-n">CONSECUTIVO</td>
            <td class="b t-c t-n"><?= $iduditoria; ?></td>
            <td class="b t-c t-n">FECHA</td>
            <td class="b t-c t-n"><?= date('d/m/Y', strtotime($infoauditoria['fecha'])); ?></td>
            <td class="b t-c t-n">LUGAR</td>
            <td class="b t-c t-n"><?= $infoauditoria['lugar']; ?></td>
          </tr>
          <tr>
            <td class="b t-c t-n">TEMA Y/O ASUNTO)</td>
            <td class="b t-c t-n" colspan="5">INVENTARIO FISICO</td>
          </tr>
          <tr>
            <td class="b t-c t-n" colspan="6">&nbsp; </td>
          </tr>
          <tr>
            <td class="b t-c t-n" colspan="3">NOMBRE(S) Y APELLIDOS (S)</td>
            <td class="b t-c t-n" colspan="3">CARGO</td>
          </tr>
          <? $sql0 = $mysqli->query("SELECT nombre, cargo FROM `z_auditorias_auditores` WHERE  id_auditoria=$iduditoria");
          while($row0 = $sql0->fetch_assoc()){ ?>
          <tr>
            <td class="b t-l" colspan="3"><?= $row0['nombre']; ?></td>
            <td class="b t-l" colspan="3"><?= $row0['cargo']; ?></td>
          </tr>
          <? } ?>
          <tr>
            <td class="b t-c t-n" colspan="3">&nbsp; </td>
            <td class="b t-c t-n" colspan="3">&nbsp; </td>
          </tr>
          <tr>
            <td class="b t-c t-n" colspan="6">DESARROLLO DEL ACTA</td>
          </tr>
        </table>
        <br>
        <p><b>ALCANCE</b><br>Toma física de inventarios con corte <b>(<?= $infoauditoria['fecha_proximo']; ?>)</b></p>
        <p class="t-j"><b>DESARROLLO</b><br>En la ciudad de (<? $infomuni = sinfo($infoauditoria['id_municipio'], 'z_municipios'); $infodepa = sinfo($infomuni['departamento'], 'z_departamentos');  echo $infomuni['municipio'].', '.$infodepa['departamento']; ?>), a las (<?= $infoauditoria['hora_inicio']; ?>), en las instalaciones de GUIATRANSPORTES LTDA, durante los días o el día (Dia de Mes del Año), se realiza toma de inventario físico:</b></p>
        <p>El auditor explicó a los asistentes el propósito general de la auditoria a realizar.</p>
        <p>Consiste en verificar el inventario físico con los datos suministrados por la coordinadora de inventario.</p>
        <br>
        <table>
          <tr>
            <td class="b t-c t-n" >ASPECTOS AUDITABLES</td>
            <td class="b t-c t-n" >CUMPLIMIENTO Y OBSERVACIONES</td>
          </tr>
          <tr>
            <td class="b t-c" >Toma física de inventarios de toda la institución</td>
            <td class="b t-c" >Realizar toma física de inventario y validar su cumplimiento</td>
          </tr>
          <tr>
            <td class="b t-c" >Verificación de existencias, frente al inventario existente</td>
            <td class="b t-c" >Validar la información en físico comparada con el inventario suministrado por inventarios.</td>
          </tr>
          <tr>
            <td class="b t-c" >Situación evidenciada</td>
            <td class="b t-c" >Documentar los hallazgos e informar a Subdirección Administrativa y Financiera</td>
          </tr>
        </table>
        <p class="t-n">TOMA FISICA DE INVENTARIOS</p>
        <p>Los días o el día (Dia de Mes del Año) se realizó toma física de inventarios de la bodega SCDS. Se realiza el conteo bajo el informe de Inventarios. De igual forma se verificó la disposición y la conservación de los elementos.</p>
        
        <p class="t-n">Verificación de existencias frente al reporte de inventarios</p>
        <? $reporte ='';
          $sql0 = $mysqli->query("SELECT * FROM `z_auditorias_novedades` WHERE  id_auditoria=$iduditoria");
          while($row0 = $sql0->fetch_assoc()){ 
              $infop = sinfo($row0['id_producto'],'z_productos');
              $reporte .= $infop['no_parte'].': ';
              $reporte .= $row0['novedad'].'<br>';
          } ?>
        <p><?= substr($reporte, 0 ,2500); ?></p>
    </div>
    <div class="page">
        <div class="header">
            <div><img src="<?= $r.$logosite; ?>" width="120px"></div>
            <div><p>Formato registro inventario</p></div>
            <div class="t-l"><p>Código: FR-OPE-001<br>Versión:001<br>Fecha:26/06/2024</p></div>
        </div>
        <p><?= substr($reporte, 2500 ); ?></p>
        <p class="t-n">Situación evidenciada</p>
        <p class="h"><?= $infoauditoria['situacion_evidenciada']; ?></p>
        <p>Para los demás elementos se realizó una revisión el cual presenta conformidad de acuerdo al listado de inventario.</p>
        <p class="t-n">Recomendaciones</p>
        <p class="h"><?= $infoauditoria['recomendaciones']; ?></p>
    </div>
    <div class="page">
        <div class="header">
            <div><img src="<?= $r.$logosite; ?>" width="120px"></div>
            <div><p>Formato registro inventario</p></div>
            <div class="t-l"><p>Código: FR-OPE-001<br>Versión:001<br>Fecha:26/06/2024</p></div>
        </div>
        <p class="t-n">1. Plan de acción</p>
        <table>
          <tr>
            <td class="b t-c t-n" >Compromiso</td>
            <td class="b t-c t-n" >Responsable</td>
            <td class="b t-c t-n" >Fecha de cumplimiento</td>
            <td class="b t-c t-n" >Seguimiento</td>
          </tr>
          <tr>
            <td class="b t-c" ><?= $infoauditoria['compromiso']; ?></td>
            <td class="b t-c" ><?= $infoauditoria['responsable']; ?></td>
            <td class="b t-c" ><?= $infoauditoria['fecha_cumplimiento']; ?></td>
            <td class="b t-c" ><?= $infoauditoria['seguimiento']; ?></td>
          </tr>
        </table>
        <p class="h h-100">&nbsp;</p>
        <p class="t-n">___________________________________________________<br>EDWIN SMITH GONZALEZ<br>AUDITADO</p>
        <p class="h h-100">&nbsp;</p>
        <p class="t-n">___________________________________________________<br>JEISSON ZUÑIGA<br>GERENTE ADMINSITRATIVO</p>
        <p class="h h-100">&nbsp;</p>
        <p class="t-n">___________________________________________________<br>XXXXXXXXXXXXXXXXXXXX<br>AUDITOR</p>
    </div>
   <div class="fixed-buttons">
        <button onclick="guardarComoPDF()">
            <i class="fas fa-file-pdf fa-2x"></i>
        </button>
        <button onclick="imprimirPagina()">
            <i class="fas fa-print fa-2x"></i>
        </button>
    </div>

   <script>
        function guardarComoPDF() {
            const paginas = document.querySelectorAll('.page');
            const opciones = {
                margin:       0,
                filename:     'documento.pdf',
                image:        { type: 'jpeg', quality: 0.98 },
                html2canvas:  { scale: 2 },
                jsPDF:        { unit: 'in', format: 'letter', orientation: 'portrait' }
            };

            const elements = Array.from(paginas);

            // Combine all page elements into a single container
            const container = document.createElement('div');
            elements.forEach(el => container.appendChild(el.cloneNode(true)));

            html2pdf().from(container).set(opciones).save();
        }
          function imprimirPagina() {
            window.print();
        }

        // Deshabilitar clic derecho
        document.addEventListener('contextmenu', function (e) {
            e.preventDefault();
        });

        // Deshabilitar F12 y teclas de desarrollo
        document.addEventListener('keydown', function (e) {
            if (e.key === 'F12' || (e.ctrlKey && (e.key === 'I' || e.key === 'J' || e.key === 'U')) || (e.metaKey && e.key === 'I')) {
                e.preventDefault();
            }
        });

        // Deshabilitar copiar y pegar
        document.addEventListener('copy', function (e) {
            e.preventDefault();
        });
        
        document.addEventListener('paste', function (e) {
            e.preventDefault();
        });

        document.addEventListener('cut', function (e) {
            e.preventDefault();
        });
    </script>
    
</body>
</html>