<?php
$r= '../';
$titlepage='QUIEN TRANSPORTA';
require_once($r."inc/config.php");
validSession($r);
$mysqli = connectDB($r);
$spe = $_SESSION['perfil'];
$idusuario = $_SESSION['userid'];
roleaccess(120);
include $r."inc/head.php"; ?>

<body class="fixed-nav sticky-footer sidenav-toggled bg-dark" id="page-top">
    <?php include $r."inc/nav.php"; ?>
 
    <div class="content-wrapper">
        <div class="container-fluid">
          <!-- Example DataTables Card-->
          <div class="card mb-3">
            <div class="h3 card-header">
              <i class="fa fa-table"></i> <?= $titlepage; ?>
              <? if(viewroleaccess(121)){ ?><a class="btn text-primary float-right p-0 ml-3" onclick="NewUser()" title="Nuevo usuario"><i class="fa fa-plus-circle fa-2x"></i></a><? } ?>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-bordered table-striped" id="dataTable" width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th>ID</th>
                      <th>nombre</th>
                      <th>Empresa</th>
                      <th>Correo</th>
                      <th>Tipo usuario</th>
                      <th style="max-width: 120px;"><i class="fa fa-gear"></i></th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th>ID</th>
                      <th>nombre</th>
                      <th>Empresa</th>
                      <th>Correo</th>
                      <th>Tipo usuario</th>
                      <th style="max-width: 120px;"><i class="fa fa-gear"></i></th>
                    </tr>
                  </tfoot>
                  <tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
    </div>
      
  
    <!-- Modal Nuevo-->
    <div class="modal fade" id="ModalUser" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="ModalUserTitle">C</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form id="newformulario" action="acciones_conductor.php" method="POST">
              <input type="hidden" name="ActionConductor">
              <div class="form-group">
                <label>Nombres</label>
                <input type="text" name="nombre" class="form-control" placeholder="Nombre de usuario" required>
              </div>
              <? /*<div class="form-group">
                <label>Numero de identificacion</label>
                <input type="text" name="nuip" class="form-control" placeholder="Numero de identificacion Personal" required>
              </div>
              <div class="form-group">
                <label>Correo</label>
                <input type="text" name="correo" class="form-control" placeholder="Correo electronico" required>
              </div> */ ?>
              <div class="form-group">
                <label>Teléfono</label>
                <input type="text" name="telefono" class="form-control" placeholder="Telefono de Contacto" required>
              </div>
              <? if(viewroleaccess(126)){ ?>
              <div class="form-group">
                <label>Empresa</label>
                <select name="empresa" class="form-control" required>
                  <option selected disabled>Empresa del usuario</option>
                  <?php $qry1 = $mysqli->query("SELECT * FROM z_usuarios_empresas");
                        while($row1 = $qry1->fetch_assoc()){ ?>
                  <option value="<?= $row1['id']; ?>"><?= $row1['empresa']; ?></option>
                  <? } ?>
              </select>
              </div>
              <? }else{ ?>
              <input type="hidden" name="empresa" value="<?= $_SESSION['empresa']; ?>">
              <? } ?>
            </form>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" form="newformulario" class="btn btn-primary">GUARDAR</button>
          </div>
        </div>
      </div>
    </div>
  <?php include $r."inc/foot.php"; ?>
  <script>
    $('#dataTable').DataTable({
      "processing": true,
      "serverSide": true,
      "ajax": 'server_side/conductores.php',
      "paging": true,
      "ordering": false,
      "searching": true,
      "dom": 'Bfrtip', // Agrega B para los botones
      "buttons": [
        'copy', 'csv', 'excel', 'pdf', 'print'
        // Puedes agregar más botones según tus necesidades
      ],
      // Otras configuraciones...
    });
    function NewUser(){
        $('#ModalUser').modal('show');
        $('#ModalUserTitle').html('NUEVO TRANSPORTADOR');
        $('input[name=ActionConductor]').removeAttr('value');
    }
    
    function editar(id){
        $.post( "acciones.php", { infouser: id })
          .done(function( response ) {
            if (response.success) {
                $('#ModalUser').modal('show');
                $('input[name=nombre]').val(response.data.nombre);
                $('input[name=empresa]').val(response.data.empresa);
                $('input[name=nuip]').val(response.data.nuip);
                $('input[name=correo]').val(response.data.correo);
                $('input[name=telefono]').val(response.data.telefono);
                $('select[name=empresa]').val(response.data.idempresa);
                $('input[name=ActionConductor]').val(id);
                $('#ModalUserTitle').html('EDITAR USUARIO');
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                $("#error-message").html(response.message);
            }
        });
        
    }
    
    function estado(element, id){
        $.post( "acciones.php", { estado: id })
          .done(function( response ) {
            if (response.success) {
                $("#dataTable").DataTable().ajax.reload();
                swal(response.message);
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                swal(response.message);
            }
        });
    }
    
    function eliminar(id){
        swal({
          title: "¿Estás seguro?",
          text: "No podrás recuperar a este usuario.",
          type: "warning",
          showCancelButton: true,
          cancelButtonText: 'No',
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Sí, eliminar",
          closeOnConfirm: false
        },
        function(){
            $.post( "acciones_conductor.php", { eliminar: id })
              .done(function( response ) {
                if (response.success) {
                    $("#dataTable").DataTable().ajax.reload();
                    swal(response.message);
                } else {
                    // Mostrar un mensaje de error en algún lugar del formulario
                    swal(response.message);
                }
            });
        });
    }
    function reset(id,nuip){
        swal({
          title: "¿Estás seguro?",
          text: "De restablecer la contraseña del usuario",
          type: "warning",
          showCancelButton: true,
          cancelButtonText: 'No',
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Si, Restablecer!",
          closeOnConfirm: false,
          html: false
        }, function(){
          $.post( "acciones_conductor.php", { ResetPassword: id, nuip: nuip } ).done(function( data ) {
             swal(data.message);
          });
        });
    }
    
    $(document).ready(function(){
        //Formualario
        $('#newformulario').on('submit', function(e) {
            // Evita el comportamiento predeterminado de envío del formulario
            e.preventDefault();
            
            // Obtén los datos del formulario
            var formData = $(this).serialize();
            
            // Realiza la solicitud Ajax
            $.ajax({
              type: $('#newformulario').attr('method'), // O el método que estés utilizando en tu formulario
              url: $('#newformulario').attr('action'), // La URL a la que quieres enviar los datos
              data: formData, // Los datos del formulario serializados
              dataType:'json',
              success: function(response) {
                // Maneja la respuesta del servidor si es necesario
                if (response.success) {
                    $("#dataTable").DataTable().ajax.reload();
                    $('#ModalUser').modal('hide');
                    $('#newformulario')[0].reset();
                    swal(response.message);
                } else {
                    // Mostrar un mensaje de error en algún lugar del formulario
                    swal(response.message);
                }
              },
              error: function(xhr, status, error) {
                // Maneja cualquier error que pueda ocurrir durante la solicitud
                console.error('Error en la solicitud:', error);
              }
            });
          });

    // Resto del código...
  });
  </script>
</body>
</html>   